/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.timeseries.univariate.TimeSeries;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filtration {
    private double[] G;
    private double[] M;
    private double[] m;
    private double[] H;

    public double dB(int t2) {
        return this.m[t2];
    }

    public double[] dBt() {
        return Arrays.copyOf(this.m, this.m.length);
    }

    public double dt(int t2) {
        return this.H[t2];
    }

    public double[] dt() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    public double T(int t2) {
        return this.M[t2];
    }

    public double B(int t2) {
        return this.G[t2];
    }

    public Filtration(TimeSeries<Double> Bt2) {
        TimeSeries.Iterator<TimeSeries.Entry<Double>> a2;
        int a3 = Bt2.size();
        this.M = new double[a3];
        this.G = new double[a3];
        int a4 = 0;
        TimeSeries.Iterator<TimeSeries.Entry<Double>> iterator = a2 = Bt2.iterator();
        while (iterator.hasNext()) {
            TimeSeries.Entry a5 = (TimeSeries.Entry)a2.next();
            this.M[a4] = (Double)a5.time;
            this.G[a4] = (Double)a5.value;
            ++a4;
            iterator = a2;
        }
        this.m = R.diff(this.G);
        this.H = R.diff(this.M);
    }

    public double[] Bt() {
        return Arrays.copyOf(this.G, this.m.length);
    }

    public double[] T() {
        return Arrays.copyOf(this.M, this.M.length);
    }

    public int size() {
        return this.m.length;
    }
}

