/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde;

import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.DiscretizedSDE;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.Ft;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.SDE;

public class Milstein
implements DiscretizedSDE {
    public final SDE sde;

    public Ft getNewFt() {
        return this.sde.getFt();
    }

    public double dXt(Ft ft) {
        double a2 = this.sde.mu.evaluate(ft);
        double a3 = this.sde.sigma.evaluate(ft);
        double a4 = this.db(ft);
        double a5 = ft.dt();
        double a6 = ft.Zt();
        double a7 = a2 * a5;
        a7 += a3 * ft.dWt();
        return a7 += 0.5 * a4 * a3 * a5 * (a6 * a6 - 1.0);
    }

    public Milstein(SDE sde) {
        this.sde = sde;
    }

    public double db(final Ft ft) {
        UnivariateRealFunction a2 = new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double x2) {
                Ft a2 = ft.deepCopy();
                a2.setXt(x2);
                return Milstein.this.sde.sigma.evaluate(a2);
            }
        };
        double a3 = new FiniteDifference(a2, 1, FiniteDifference.Type.CENTRAL).evaluate(ft.Xt());
        return a3;
    }
}

