/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test;

import com.numericalmethod.suanshu.stats.distribution.univariate.EmpiricalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public abstract class HypothesisTest {
    protected volatile double testStatistics;
    public final int N;
    public final int k;
    protected volatile double pValue;

    public abstract String alternativeHypothesis();

    public double testStatistics() {
        return this.testStatistics;
    }

    public double pValue() {
        return this.pValue;
    }

    public abstract String nullHypothesis();

    public static double oneSidedPvalue(UnivariateDistribution F2, double x2) {
        if (F2 instanceof EmpiricalDistribution) {
            return 1.0 - F2.cdf(x2) + F2.density(x2);
        }
        return 1.0 - F2.cdf(x2);
    }

    protected HypothesisTest(double[] ... samples) {
        int a2;
        this.k = samples.length;
        int a3 = 0;
        int n = a2 = 0;
        while (n < this.k) {
            a3 += samples[a2] != null ? samples[a2].length : 0;
            n = ++a2;
        }
        this.N = a3;
    }

    public boolean rejectNull(double alpha) {
        return this.pValue() < alpha;
    }
}

