/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.normality;

import com.numericalmethod.suanshu.stats.descriptive.moment.Kurtosis;
import com.numericalmethod.suanshu.stats.descriptive.moment.Skewness;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.distribution.normality.JarqueBeraDistribution;

public class JarqueBera
extends HypothesisTest {
    public final int nSim = 50000;

    public JarqueBera(double[] sample, boolean isExact) {
        double[][] dArrayArray = new double[1][];
        dArrayArray[0] = sample;
        super(dArrayArray);
        this.nSim = 50000;
        Skewness a2 = new Skewness(sample);
        Kurtosis a3 = new Kurtosis(sample);
        double a4 = a2.sample();
        double a5 = a3.sample();
        this.testStatistics = (a4 * a4 + a5 * a5 / 4.0) * (double)this.N / 6.0;
        UnivariateDistribution a6 = new ChiSquareDistribution(2.0);
        if (isExact) {
            if (this.N <= 2000) {
                a6 = new JarqueBeraDistribution(this.N, 50000);
            }
        }
        this.pValue = JarqueBera.oneSidedPvalue(a6, this.testStatistics);
    }

    public String alternativeHypothesis() {
        return b.C("q|c|ug3`tp?gsplzaft4og#`dp/qpvngG5\\aBa\\gUf\u001f}K5U{J8]qR:");
    }

    public String nullHypothesis() {
        return b.C("XTMR\u001eOU_\u0012HZ_AUPIY\u001bHTJ\u001bYRG\u001bDBE^VI:PlHjTnSa\u001bpHs\u001be");
    }

    public JarqueBera(double[] sample) {
        this(sample, false);
    }
}

