/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.pearson;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.ProbabilityMassFunction;
import com.numericalmethod.suanshu.stats.random.RNG;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.sampling.discrete.DiscreteSampling;
import java.util.Arrays;
import java.util.Iterator;

public class AS159 {
    private final RandomNumberGenerator B;
    private final int[] G;
    private final double[] M;
    private final int m;
    private final int[] H;

    public RandomMatrix sample() {
        int a2;
        int a3 = this.H.length - 1;
        int a4 = this.G.length - 1;
        DenseMatrix a5 = new DenseMatrix(a3, a4);
        double a6 = 1.0;
        int[] a7 = Arrays.copyOf(this.G, this.G.length);
        int n = a2 = 1;
        while (n < a3) {
            int a8;
            int a9 = this.H[a2];
            int n2 = a8 = 1;
            while (n2 < a4) {
                Integer a10;
                int a11;
                int a12 = 0;
                int n3 = a11 = a8;
                while (n3 <= a4) {
                    a12 += a7[a11];
                    n3 = ++a11;
                }
                a11 = a12 - a7[a8];
                int a13 = a12 - a9;
                int a14 = a12 - a7[a8] - a9;
                if (a12 == 0) {
                    int n4 = a8;
                    while (n4 <= a4) {
                        int a15;
                        a5.set(a2, a15, 0.0);
                        n4 = ++a15;
                    }
                    break;
                }
                ConditionalDistribution a16 = new ConditionalDistribution(a9, a7[a8], a12, a14, a11, a13);
                DiscreteSampling<Integer> a17 = new DiscreteSampling<Integer>(a16, a16);
                Integer n5 = a10 = null;
                while (n5 == null) {
                    n5 = a17.getSample(this.B.nextDouble());
                }
                a5.set(a2, a8, a10.intValue());
                a9 -= a10.intValue();
                int n6 = a8++;
                a7[n6] = a7[n6] - a10;
                a6 *= a16.evaluate(a10);
                n2 = a8;
            }
            a5.set(a2, a4, a9);
            int n7 = a4;
            a7[n7] = a7[n7] - a9;
            n = ++a2;
        }
        int n8 = a2 = 1;
        while (n8 <= a4) {
            a5.set(a3, a2, a7[a2]);
            n8 = ++a2;
        }
        return new RandomMatrix(a5, a6);
    }

    public AS159(int[] rowSums, int[] colSums) {
        this(rowSums, colSums, new RNG());
    }

    public boolean validate(Matrix A) {
        int a2;
        int a3;
        int n = a3 = 1;
        while (n <= A.nRows()) {
            int n2 = a2 = 1;
            while (n2 <= A.nCols()) {
                if (A.get(a3, a2) < 0.0) {
                    return false;
                }
                n2 = ++a2;
            }
            n = ++a3;
        }
        int[] a22 = MatrixUtils.rowSums(A);
        int n3 = a2 = 1;
        while (n3 <= A.nRows()) {
            if (a22[a2 - 1] != this.H[a2]) {
                return false;
            }
            n3 = ++a2;
        }
        a22 = MatrixUtils.colSums(A);
        int n4 = a2 = 1;
        while (n4 <= A.nCols()) {
            if (a22[a2 - 1] != this.G[a2]) {
                return false;
            }
            n4 = ++a2;
        }
        return true;
    }

    public AS159(int[] rowSums, int[] colSums, RandomNumberGenerator rng) {
        int a2;
        int a3;
        int a4;
        this.B = rng;
        SuanShuUtils.assertArgument(rowSums.length > 1, b.C("NS\\\u001a]TSN[UV_XXL\u001a^ZKVK\u001b@OQO\u0001RGM@\u001a{O9V{ZnN2\t1HyL&"));
        SuanShuUtils.assertArgument(colSums.length > 1, b.C("`}r4sz}`u{xqvvb4ptexe5na\u007fa/|icn4Ua\u0017xUt@`\u001c'\u001fwWyNyJ&"));
        int n = a4 = 0;
        while (n < rowSums.length) {
            SuanShuUtils.assertArgument(rowSums[a4] > 0, b.C("` pnr utd gt~t.ct 9w0"));
            n = ++a4;
        }
        int n2 = a4 = 0;
        while (n2 < colSums.length) {
            SuanShuUtils.assertArgument(colSums[a4] > 0, b.C("t4uz}a\u007f{=gkx9yofq4dp!?t0"));
            n2 = ++a4;
        }
        a4 = DoubleUtils.sum(rowSums);
        SuanShuUtils.assertArgument(a4 == (a3 = DoubleUtils.sum(colSums)), b.C("RO@\u0006PHV\u0006]R@\u0006KIM\u0006BOP\u0006QH]SSIN\u0006IRT\u0006bH%HmS!GjC-Sz\u0007lWcF9"));
        this.m = a4;
        this.M = new double[this.m + 1];
        this.M[0] = 0.0;
        double a5 = 0.0;
        int n3 = a2 = 1;
        while (n3 <= this.m) {
            this.M[a2] = a5 += Math.log(a2);
            n3 = ++a2;
        }
        this.H = new int[rowSums.length + 1];
        this.H[0] = 0;
        int n4 = a2 = 0;
        while (n4 < rowSums.length) {
            this.H[a2 + 1] = rowSums[a2];
            n4 = ++a2;
        }
        this.G = new int[colSums.length + 1];
        this.G[0] = 0;
        int n5 = a2 = 0;
        while (n5 < colSums.length) {
            this.G[a2 + 1] = colSums[a2];
            n5 = ++a2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConditionalDistribution
    implements Iterable<Integer>,
    ProbabilityMassFunction<Integer> {
        private final double l;
        private int k = 0;
        private final int f;
        private double J;
        private final int C;
        private int F = 0;
        private final int B;
        private int G = 0;
        private final int M;
        private double m;
        private double H;

        @Override
        public double evaluate(Integer x2) {
            if (x2 == this.k) {
                return this.J;
            }
            throw new RuntimeException(b.C("`}~g0ea{~t}}t|om$xfgs5eabv{}g{+yAfC4Rp\u0013w]ySq\\5Rz\u0004zUpE'"));
        }

        private void C() {
            double d2;
            ConditionalDistribution a2;
            double a3 = a2.G * (a2.C + a2.G);
            if (d2 > 0.0) {
                --a2.G;
                a2.m *= a3 / ((double)(a2.f - a2.G) * (double)(a2.M - a2.G));
            } else {
                a2.G = -1;
            }
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){

                @Override
                public Integer next() {
                    if (ConditionalDistribution.this.k == 0) {
                        ConditionalDistribution.this.k = ConditionalDistribution.this.B;
                        ConditionalDistribution.this.J = ConditionalDistribution.this.l;
                        ConditionalDistribution.this.H();
                        ConditionalDistribution.this.C();
                    } else if (ConditionalDistribution.this.F >= 0 && (ConditionalDistribution.this.k <= ConditionalDistribution.this.B || ConditionalDistribution.this.G < 0)) {
                        ConditionalDistribution.this.k = ConditionalDistribution.this.F;
                        ConditionalDistribution.this.J = ConditionalDistribution.this.H;
                        ConditionalDistribution.this.H();
                    } else if (ConditionalDistribution.this.G >= 0 && (ConditionalDistribution.this.k > ConditionalDistribution.this.B || ConditionalDistribution.this.F < 0)) {
                        ConditionalDistribution.this.k = ConditionalDistribution.this.G;
                        ConditionalDistribution.this.J = ConditionalDistribution.this.m;
                        ConditionalDistribution.this.C();
                    }
                    return ConditionalDistribution.this.k;
                }

                @Override
                public boolean hasNext() {
                    if (ConditionalDistribution.this.F < 0 && ConditionalDistribution.this.G < 0) {
                        return false;
                    }
                    return true;
                }
                {
                    1 a2;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
                }
            };
        }

        private ConditionalDistribution(int a2, int a3, int a4, int a5, int a6, int a7) {
            ConditionalDistribution a8;
            a8.M = a2;
            a8.f = a3;
            a8.C = a5;
            a8.B = Math.round((float)a2 * (float)a3 / (float)a4);
            a8.l = Math.exp(a8.AS159.this.M[a2] + a8.AS159.this.M[a7] + a8.AS159.this.M[a3] + a8.AS159.this.M[a6] - a8.AS159.this.M[a8.B] - a8.AS159.this.M[a3 - a8.B] - a8.AS159.this.M[a2 - a8.B] - a8.AS159.this.M[a5 + a8.B] - a8.AS159.this.M[a4]);
            a8.F = a8.B;
            a8.G = a8.B;
            a8.H = a8.l;
            a8.m = a8.l;
        }

        private void H() {
            double d2;
            ConditionalDistribution a2;
            double a3 = (a2.f - a2.F) * (a2.M - a2.F);
            if (d2 > 0.0) {
                ++a2.F;
                a2.H *= a3 / ((double)a2.F * (double)(a2.C + a2.F));
            } else {
                a2.F = -1;
            }
        }
    }

    public static class RandomMatrix {
        public final ImmutableMatrix A;
        public final double prob;

        public RandomMatrix(Matrix A, double prob) {
            this.A = new ImmutableMatrix(A);
            this.prob = prob;
        }
    }
}

