/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank.wilcoxon;

import com.numericalmethod.suanshu.number.big.BigIntegerUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import java.math.BigInteger;

public class WilcoxonRankSumDistribution
implements UnivariateDistribution {
    public final int M;
    private double[][][] H;
    public final int N;

    @Deprecated
    public double moment(double x2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double quantile(double u2) {
        int a2 = 0;
        double a3 = 0.0;
        int a4 = 0;
        int n = a2;
        while (n <= this.M * this.N) {
            int a5 = a2 + this.M * (this.M + 1) / 2;
            int n2 = a4;
            int n3 = a5;
            while (n2 <= n3 && a4 <= WilcoxonRankSumDistribution.H(this.M, this.N)) {
                a3 += this.H[this.M][this.N][a4];
                n2 = ++a4;
                n3 = a5;
            }
            if (a3 > u2) break;
            n = ++a2;
        }
        return a2;
    }

    public WilcoxonRankSumDistribution(int M, int N) {
        int a2;
        int a3;
        int a4;
        this.M = M;
        this.N = N;
        this.H = new double[M + 1][N + 1][];
        int n = a4 = 1;
        while (n <= N) {
            this.H[0][a4] = new double[1];
            this.H[0][a4][0] = 1.0;
            n = ++a4;
        }
        int n2 = a4 = 1;
        while (n2 <= M) {
            a3 = WilcoxonRankSumDistribution.H(a4, 0);
            this.H[a4][0] = new double[a3 + 1];
            this.H[a4][0][a3] = 1.0;
            n2 = ++a4;
        }
        int n3 = a4 = 1;
        while (n3 <= M) {
            int n4 = a3 = 1;
            while (n4 <= N) {
                int a5 = WilcoxonRankSumDistribution.H(a4, a3);
                this.H[a4][a3] = new double[a5 + 1];
                int n5 = a4 * (a4 + 1) / 2;
                while (n5 <= a5) {
                    double a6;
                    double d2 = a2 >= this.H[a4][a3 - 1].length ? 0.0 : (a6 = this.H[a4][a3 - 1][a2]);
                    double a7 = a2 - a4 - a3 >= 0 ? this.H[a4 - 1][a3][a2 - a4 - a3] : 0.0;
                    this.H[a4][a3][a2] = a6 + a7;
                    n5 = ++a2;
                }
                n4 = ++a3;
            }
            n3 = ++a4;
        }
        int n6 = a4 = 1;
        while (n6 <= M) {
            int n7 = a3 = 1;
            while (n7 <= N) {
                BigInteger a8 = BigIntegerUtils.combination(a4 + a3, a4);
                int n8 = a2 = 0;
                while (n8 < this.H[a4][a3].length) {
                    double[] dArray = this.H[a4][a3];
                    int n9 = a2++;
                    dArray[n9] = dArray[n9] / a8.doubleValue();
                    n8 = a2;
                }
                n7 = ++a3;
            }
            n6 = ++a4;
        }
    }

    public double variance() {
        return (double)(this.M * this.N * (this.M + this.N + 1)) / 12.0;
    }

    public double mean() {
        return (double)(this.M * this.N) / 2.0;
    }

    public double density(double x2) {
        return this.H[this.M][this.N][(int)x2 + this.M * (this.M + 1) / 2];
    }

    @Deprecated
    public double median() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double cdf(double x2) {
        int a2;
        int a3 = (int)x2 + this.M * (this.M + 1) / 2;
        double a4 = 0.0;
        int n = a2 = 0;
        while (n <= WilcoxonRankSumDistribution.H(this.M, this.N)) {
            if (a2 <= a3) {
                a4 += this.H[this.M][this.N][a2];
            }
            n = ++a2;
        }
        return a4;
    }

    private static int H(int a2, int a3) {
        return a2 * (a2 + 2 * a3 + 1) / 2;
    }

    public double pValue(double x2) {
        double a2 = this.cdf(x2);
        double a3 = this.pValue1SidedGreater(x2);
        return 2.0 * Math.min(a3, a2);
    }

    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double pValue1SidedGreater(double x2) {
        int a2;
        int a3 = (int)x2 + this.M * (this.M + 1) / 2;
        double a4 = 0.0;
        int n = a2 = 0;
        while (n <= WilcoxonRankSumDistribution.H(this.M, this.N)) {
            if (a2 >= a3) {
                a4 += this.H[this.M][this.N][a2];
            }
            n = ++a2;
        }
        return a4;
    }

    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }
}

