/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank.wilcoxon;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class WilcoxonSignedRankDistribution
implements UnivariateDistribution {
    public final int N;
    private double[][] H;

    public double mean() {
        return (double)(this.N * (this.N + 1)) / 4.0;
    }

    @Deprecated
    public double skew() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public WilcoxonSignedRankDistribution(int N) {
        int a2;
        int a3;
        int a4;
        this.N = N;
        this.H = new double[N + 1][];
        this.H[0] = new double[1];
        this.H[0][0] = 1.0;
        int n = a4 = 1;
        while (n <= N) {
            a3 = WilcoxonSignedRankDistribution.H(a4);
            this.H[a4] = new double[a3 + 1];
            int n2 = a2 = 0;
            while (n2 <= a3) {
                double a5;
                double d2 = a2 < this.H[a4 - 1].length ? this.H[a4 - 1][a2] : (a5 = 0.0);
                double a6 = a2 - a4 >= 0 ? this.H[a4 - 1][a2 - a4] : 0.0;
                this.H[a4][a2] = a5 + a6;
                n2 = ++a2;
            }
            n = ++a4;
        }
        int n3 = a4 = 1;
        while (n3 <= N) {
            int n4 = a3 = 0;
            while (n4 < this.H[a4].length) {
                int n5 = a2 = 1;
                while (n5 <= a4) {
                    double[] dArray = this.H[a4];
                    int n6 = a3;
                    dArray[n6] = dArray[n6] / 2.0;
                    n5 = ++a2;
                }
                n4 = ++a3;
            }
            n3 = ++a4;
        }
    }

    public double pValue(double x2) {
        double a2 = this.cdf(x2);
        double a3 = this.pValue1SidedGreater(x2);
        return 2.0 * Math.min(a3, a2);
    }

    public double cdf(double x2) {
        int a2;
        double a3 = 0.0;
        int n = a2 = 0;
        while (n <= WilcoxonSignedRankDistribution.H(this.N)) {
            if ((double)a2 <= x2) {
                a3 += this.H[this.N][a2];
            }
            n = ++a2;
        }
        return a3;
    }

    @Deprecated
    public double moment(double x2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    private static int H(int a2) {
        return a2 * (a2 + 1) / 2;
    }

    @Deprecated
    public double median() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double quantile(double u2) {
        int a2 = 0;
        double a3 = 0.0;
        int a4 = 0;
        int n = a2;
        while (n <= WilcoxonSignedRankDistribution.H(this.N)) {
            int n2 = a4;
            int n3 = a2;
            while (n2 <= n3 && a4 <= WilcoxonSignedRankDistribution.H(this.N)) {
                a3 += this.H[this.N][a4];
                n2 = ++a4;
                n3 = a2;
            }
            if (a3 >= u2) break;
            n = ++a2;
        }
        return a2;
    }

    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double density(double x2) {
        return this.H[this.N][(int)x2];
    }

    public double pValue1SidedGreater(double x2) {
        int a2;
        double a3 = 0.0;
        int n = a2 = 0;
        while (n <= WilcoxonSignedRankDistribution.H(this.N)) {
            if ((double)a2 >= x2) {
                a3 += this.H[this.N][a2];
            }
            n = ++a2;
        }
        return a3;
    }

    static {
        Package.getInstance(b.C("BDSE\u0006")).validate();
    }

    public double variance() {
        return (double)(this.N * (this.N + 1) * (2 * this.N + 1)) / 24.0;
    }

    @Deprecated
    public double kurtosis() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }
}

