/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity;

import com.numericalmethod.suanshu.stats.regression.linear.Residuals;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OlsRegression;
import com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity.Heteroskedasticity;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class BreuschPagan
extends Heteroskedasticity {
    private final boolean H;

    public double testStatistics() {
        OlsRegression a2 = this.getAuxiliaryRegression();
        return this.H ? (double)this.n * a2.residuals.R2 : 0.5 * a2.residuals.fitted.innerProduct(a2.residuals.fitted);
    }

    public BreuschPagan(Residuals residuals, boolean studentized) {
        super(residuals);
        this.H = studentized;
    }

    public OlsRegression getAuxiliaryRegression() {
        ImmutableVector a2 = this.residuals.residuals;
        double a3 = Math.pow(a2.norm(), 2.0) / (double)this.n;
        Vector a4 = this.H ? a2.pow(2.0).minus(a3) : a2.pow(2.0).scaled(1.0 / a3).minus(1.0);
        OlsRegression a5 = this.auxiliaryOlsRegression(a4, this.residuals);
        return a5;
    }
}

