/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity;

import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.LmProblem;
import com.numericalmethod.suanshu.stats.regression.linear.Residuals;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OlsRegression;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.vector.doubles.Vector;

abstract class Heteroskedasticity
extends HypothesisTest {
    protected final Residuals residuals;
    protected final int n;

    public double testStatistics() {
        OlsRegression a2 = this.getAuxiliaryRegression();
        return (double)this.n * a2.residuals.R2;
    }

    Heteroskedasticity(Residuals a2) {
        super(new double[0][]);
        Heteroskedasticity a3;
        a3.residuals = a2;
        a3.n = a2.problem.nObs();
    }

    public String alternativeHypothesis() {
        return b.C("F[T@S\u0013\\A\u001aPV\\ZZI[M]@^\u0006[@FOAFAMVISaGxQ\u007fG,");
    }

    protected ChiSquareDistribution getX2() {
        return new ChiSquareDistribution(this.residuals.problem.nExogenousFactors());
    }

    public String nullHypothesis() {
        return b.C("ydk\u007fl,c~%di`n\u007fihymmyposy,");
    }

    protected abstract OlsRegression getAuxiliaryRegression();

    public double pValue() {
        return Heteroskedasticity.oneSidedPvalue(this.getX2(), this.testStatistics());
    }

    protected OlsRegression auxiliaryOlsRegression(Vector y2, Residuals residuals) {
        LmProblem a2 = new LmProblem(y2, residuals.problem.X(), true);
        return new OlsRegression(a2);
    }
}

