/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.LmProblem;
import com.numericalmethod.suanshu.stats.regression.linear.Residuals;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OlsRegression;
import com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity.Heteroskedasticity;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class White
extends Heteroskedasticity {
    private final int m;
    private final int H;

    protected OlsRegression getAuxiliaryRegression() {
        OlsRegression a2 = null;
        if (this.H < this.n) {
            ImmutableVector a3 = this.residuals.residuals;
            double a4 = Math.pow(a3.norm(), 2.0) / (double)this.n;
            Vector a5 = a3.pow(2.0).minus(a4);
            a2 = this.auxiliaryOlsRegression(a5, this.residuals);
        }
        return a2;
    }

    public double testStatistics() {
        if (this.H < this.n) {
            return super.testStatistics();
        }
        return this.n;
    }

    public White(Residuals residuals) {
        super(residuals);
        this.m = residuals.problem.nExogenousFactors();
        this.H = this.m + this.m * (this.m + 1) / 2;
    }

    protected ChiSquareDistribution getX2() {
        return new ChiSquareDistribution(this.H);
    }

    protected OlsRegression auxiliaryOlsRegression(Vector y2, Residuals residuals) {
        int a2;
        Matrix a3 = residuals.problem.X();
        double[][] a4 = new double[this.H][];
        int a5 = 0;
        int n = a2 = 1;
        while (n <= this.m) {
            a4[a5++] = a3.getColumn(a2).toArray();
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.m) {
            int n3 = a2;
            while (n3 <= this.m) {
                int a6;
                a4[a5++] = this.H(a3.getColumn(a2), a3.getColumn(a6));
                n3 = ++a6;
            }
            n2 = ++a2;
        }
        Matrix a22 = new DenseMatrix(a4).t();
        LmProblem a7 = new LmProblem(y2, a22, true);
        return new OlsRegression(a7);
    }

    private double[] H(Vector a2, Vector a3) {
        int a4;
        int a5 = a2.size();
        double[] a6 = new double[a5];
        int n = a4 = 1;
        while (n <= a5) {
            a6[a4 - 1] = a2.get(a4) * a3.get(a4);
            n = ++a4;
        }
        return a6;
    }
}

