/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.variance;

import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;

public class Bartlett
extends HypothesisTest {
    public final double df;

    public String nullHypothesis() {
        return b.C("uy{4`zcaptk}w{;begnunvfg,t}q(pzaU9");
    }

    public Bartlett(double[] ... samples) {
        super(samples);
        int a2;
        int a3;
        double a4 = 0.0;
        double[] a5 = new double[this.k];
        int n = a3 = 0;
        while (n < this.k) {
            a5[a3] = new Variance(samples[a3]).value();
            a4 += (double)(samples[a3].length - 1) * a5[a3];
            n = ++a3;
        }
        a4 /= (double)(this.N - this.k);
        double a22 = 0.0;
        double a6 = 0.0;
        int n2 = a2 = 0;
        while (n2 < this.k) {
            a22 += (double)(samples[a2].length - 1) * Math.log(a5[a2]);
            a6 += 1.0 / (double)(samples[a2].length - 1);
            n2 = ++a2;
        }
        this.testStatistics = ((double)(this.N - this.k) * Math.log(a4) - a22) / (1.0 + (a6 - 1.0 / (double)(this.N - this.k)) / (double)(3 * (this.k - 1)));
        this.df = this.k - 1;
        ChiSquareDistribution a32 = new ChiSquareDistribution(this.df);
        this.pValue = Bartlett.oneSidedPvalue(a32, this.testStatistics);
    }

    public String alternativeHypothesis() {
        return b.C("t`6ytuaa=`iz9b{gluhvdg\"t\u007fq.q`rlpGqX!");
    }
}

