/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.AutoCovarianceFunction;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public abstract class InnovationAlgorithmImpl {
    private Matrix[] m;
    private Matrix[][] H;
    protected MultiVariateTimeSeries XtHat;

    public ImmutableMatrix getTheta(int i2, int j) {
        return new ImmutableMatrix(this.H[i2][j]);
    }

    protected void run(int t2, AutoCovarianceFunction K) {
        int a2;
        this.m = new Matrix[t2 + 1];
        this.H = new Matrix[t2 + 1][t2 + 1];
        this.m[0] = K.get(1, 1);
        int n = a2 = 1;
        while (n <= t2) {
            int a3;
            int n2 = a3 = 0;
            while (true) {
                int a4;
                if (n2 > a2 - 1) break;
                this.H[a2][a2 - a3] = K.get(a2 + 1, a3 + 1);
                int n3 = a4 = 0;
                while (true) {
                    if (n3 > a3 - 1) break;
                    Matrix a5 = this.H[a2][a2 - a4].multiply(this.m[a4]).multiply(this.H[a3][a3 - a4].t());
                    this.H[a2][a2 - a3] = this.H[a2][a2 - a3].minus(a5);
                    n3 = ++a4;
                }
                this.H[a2][a2 - a3] = this.H[a2][a2 - a3].multiply(new Inverse(this.m[a3]));
                n2 = ++a3;
            }
            this.m[a2] = K.get(a2 + 1, a2 + 1);
            int n4 = a3 = 0;
            while (true) {
                if (n4 > a2 - 1) break;
                Matrix a6 = this.H[a2][a2 - a3].multiply(this.m[a3]).multiply(this.H[a2][a2 - a3].t());
                this.m[a2] = this.m[a2].minus(a6);
                n4 = ++a3;
            }
            n = ++a2;
        }
    }

    public MultiVariateTimeSeries XtHat() {
        return this.XtHat;
    }

    static {
        Package.getInstance(b.C("BDSE\u0006")).validate();
    }

    public ImmutableVector XtHat(int t2) {
        Vector a2 = t2 != 0 ? this.XtHat.get(t2) : new DenseVector(this.XtHat.dimension(), 0.0);
        return new ImmutableVector(a2);
    }

    protected InnovationAlgorithmImpl() {
    }

    public ImmutableMatrix covariance(int t2) {
        return new ImmutableMatrix(this.m[t2]);
    }
}

