/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arima;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arima.arma.ArmaxModel;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class ArimaxModel {
    protected final ImmutableMatrix[] theta;
    protected final ImmutableMatrix[] phi;
    private final int H;
    protected final ImmutableMatrix psi;
    protected final ImmutableVector mu;
    protected final ImmutableMatrix sigma;

    public ArimaxModel(Matrix[] phi, int d2, Matrix[] theta, Matrix psi) {
        this(phi, d2, theta, psi, (Matrix)new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }

    public ArimaxModel(ArimaxModel that) {
        this.mu = new ImmutableVector(new DenseVector(that.mu));
        this.phi = that.phi != null ? Arrays.copyOf(that.phi, that.phi.length) : null;
        this.theta = that.theta != null ? Arrays.copyOf(that.theta, that.theta.length) : null;
        this.psi = that.psi != null ? new ImmutableMatrix(new DenseMatrix(that.psi)) : null;
        this.H = that.H;
        this.sigma = new ImmutableMatrix(new DenseMatrix(that.sigma));
    }

    public int q() {
        return this.theta != null ? this.theta.length : 0;
    }

    public ArimaxModel(Matrix[] phi, int d2, Matrix[] theta, Matrix psi, Matrix sigma) {
        this(new DenseVector(R.rep(0.0, sigma.nRows())), phi, d2, theta, psi, sigma);
    }

    public ArimaxModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix psi, Matrix sigma) {
        int a2;
        SuanShuUtils.assertArgument(d2 >= 0, b.C("p5))0e"));
        this.H = d2;
        this.mu = new ImmutableVector(mu);
        int a3 = mu.size();
        SuanShuUtils.assertArgument(phi != null || theta != null, b.C("t`6ytuaa={pp9{|5u|o5`zf5y|kah4it[zYa\u0011vW5SaR9"));
        if (phi != null) {
            this.phi = new ImmutableMatrix[phi.length];
            int n = a2 = 0;
            while (n < phi.length) {
                SuanShuUtils.assertArgument(phi[a2].nRows() == a3 && phi[a2].nCols() == a3, b.C("qtt|0TA4\u007fzzr~|x}a{s4s}la`q/vm5j4GdBuBp\u0013y]aM}@5Tr\u0004aOq\u0000vLf^pL`\bqByq{d}\u007f;"));
                this.phi[a2] = new ImmutableMatrix(phi[a2]);
                n = ++a2;
            }
        } else {
            this.phi = null;
        }
        if (theta != null) {
            this.theta = new ImmutableMatrix[theta.length];
            int n = a2 = 0;
            while (n < theta.length) {
                SuanShuUtils.assertArgument(theta[a2].nRows() == a3 && theta[a2].nCols() == a3, b.C("qtt|0XR4\u007fzzr~|x}a{s4s}la`q/vm5j4GdBuBp\u0013y]aM}@5Tr\u0004aOq\u0000vLf^pL`\bqByq{d}\u007f;"));
                this.theta[a2] = new ImmutableMatrix(theta[a2]);
                n = ++a2;
            }
        } else {
            this.theta = null;
        }
        if (psi != null) {
            SuanShuUtils.assertArgument(psi.nRows() == a3, b.C("cycol~*bc,tbv\u007f\"b{,n~p,iezyzi1nw-YdK-ZmGh\u0005mU-UdG-YeShW\u007fSb[,Yk\u0011xZh-a{a}e|lwegyd,C_TA_-tc~h9"));
            this.psi = new ImmutableMatrix(psi);
        } else {
            this.psi = null;
        }
        SuanShuUtils.assertArgument(sigma.nRows() == a3 && sigma.nCols() == a3, b.C("f}qxp4a}rarq9v\u007f5d4udtupp-yoa{}r5Zr\u0016aYq\u0012vRfLpZ`\u001aqLyC{R}M;"));
        this.sigma = new ImmutableMatrix(sigma);
    }

    public ImmutableMatrix MA(int i2) {
        return i2 == 0 ? new ImmutableMatrix((Matrix)new DenseMatrix(this.dimension(), this.dimension()).ONE()) : this.theta[i2 - 1];
    }

    public ImmutableMatrix[] AR() {
        return this.phi != null ? this.phi : null;
    }

    public ImmutableVector mu() {
        return this.mu;
    }

    public ImmutableMatrix psi() {
        return this.psi != null ? this.psi : null;
    }

    public ArmaxModel getArmax() {
        return new ArmaxModel((Vector)this.mu, (Matrix[])this.phi, (Matrix[])this.theta, (Matrix)this.psi, (Matrix)this.sigma);
    }

    public ImmutableMatrix AR(int i2) {
        return i2 == 0 ? new ImmutableMatrix((Matrix)new DenseMatrix(this.dimension(), this.dimension()).ONE()) : this.phi[i2 - 1];
    }

    public ImmutableMatrix sigma() {
        return this.sigma;
    }

    public ArimaxModel(com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.ArimaxModel model) {
        int a2;
        this.mu = new ImmutableVector(new DenseVector(R.rep(model.mu(), 1)));
        this.H = model.d();
        double[] dArray = new double[1];
        dArray[0] = model.sigma();
        this.sigma = new ImmutableMatrix(new DenseMatrix(dArray, 1, 1));
        int a3 = model.p();
        int a4 = model.q();
        this.phi = a3 != 0 ? new ImmutableMatrix[a3] : null;
        int n = a2 = 1;
        while (n <= a3) {
            double[] dArray2 = new double[1];
            dArray2[0] = model.AR(a2);
            this.phi[a2 - 1] = new ImmutableMatrix(new DenseMatrix(dArray2, 1, 1));
            n = ++a2;
        }
        this.theta = a4 != 0 ? new ImmutableMatrix[a4] : null;
        int n2 = a2 = 1;
        while (n2 <= a4) {
            double[] dArray3 = new double[1];
            dArray3[0] = model.MA(a2);
            this.theta[a2 - 1] = new ImmutableMatrix(new DenseMatrix(dArray3, 1, 1));
            n2 = ++a2;
        }
        this.psi = model.psi() != null ? new ImmutableMatrix(new DenseMatrix(model.psi(), 1, model.psi().length)) : null;
    }

    public int dimension() {
        return this.phi != null ? this.phi[0].nCols() : this.theta[0].nCols();
    }

    public ArimaxModel(Vector mu, Matrix[] phi, int d2, Matrix[] theta, Matrix psi) {
        this(mu, phi, d2, theta, psi, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public int d() {
        return this.H;
    }

    public ImmutableMatrix[] MA() {
        return this.theta != null ? this.theta : null;
    }

    public int p() {
        return this.phi != null ? this.phi.length : 0;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }
}

