/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.arma.ArmaxModel;
import java.util.Arrays;

public class ArimaxModel {
    protected final double[] psi;
    protected final double mu;
    protected final double[] AR;
    private final int H;
    protected final double[] MA;
    protected final double sigma;

    public int p() {
        return this.AR != null ? this.AR.length : 0;
    }

    public double sigma() {
        return this.sigma;
    }

    static {
        Package.getInstance(b.C("BDSE\u0006")).validate();
    }

    public double[] MA() {
        return this.MA != null ? Arrays.copyOf(this.MA, this.MA.length) : null;
    }

    public int d() {
        return this.H;
    }

    public double mu() {
        return this.mu;
    }

    public double MA(int i2) {
        return i2 == 0 ? 1.0 : this.MA[i2 - 1];
    }

    public ArimaxModel(double mu, double[] AR, int d2, double[] MA, double[] psi) {
        this(mu, AR, d2, MA, psi, 1.0);
    }

    public double[] psi() {
        return this.psi != null ? Arrays.copyOf(this.psi, this.psi.length) : null;
    }

    public ArimaxModel(ArimaxModel that) {
        this.mu = that.mu;
        this.AR = that.AR != null ? Arrays.copyOf(that.AR, that.AR.length) : null;
        this.MA = that.MA != null ? Arrays.copyOf(that.MA, that.MA.length) : null;
        this.psi = that.psi != null ? Arrays.copyOf(that.psi, that.psi.length) : null;
        this.H = that.H;
        this.sigma = that.sigma;
    }

    public ArimaxModel(double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        this(0.0, AR, d2, MA, psi, sigma);
    }

    public ArmaxModel getArmax() {
        return new ArmaxModel(this.mu, this.AR, this.MA, this.psi, this.sigma);
    }

    public ArimaxModel(double mu, double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        SuanShuUtils.assertArgument(AR != null || MA != null, b.C("ua7xut``<zqq8z}4EG'unq#YM5{qzxx4WtYz_a\u0013vY5QaT9"));
        SuanShuUtils.assertArgument(d2 >= 0, b.C("p5))0e"));
        SuanShuUtils.assertArgument(sigma >= 0.0, b.C("g|pyq5-)<e"));
        this.mu = mu;
        this.AR = AR != null ? Arrays.copyOf(AR, AR.length) : null;
        this.MA = MA != null ? Arrays.copyOf(MA, MA.length) : null;
        this.psi = psi != null ? Arrays.copyOf(psi, psi.length) : null;
        this.H = d2;
        this.sigma = sigma;
    }

    public double[] AR() {
        return this.AR != null ? Arrays.copyOf(this.AR, this.AR.length) : null;
    }

    public int q() {
        return this.MA != null ? this.MA.length : 0;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public double AR(int i2) {
        return i2 == 0 ? 1.0 : this.AR[i2 - 1];
    }

    public ArimaxModel(double[] AR, int d2, double[] MA, double[] psi) {
        this(0.0, AR, d2, MA, psi, 1.0);
    }
}

