/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.arma;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.ArimaxModel;

public class ArmaxModel
extends ArimaxModel {
    public ArmaxModel(double mu, double[] AR, double[] MA, double[] psi) {
        this(mu, AR, MA, psi, 1.0);
    }

    public ArmaxModel(double[] AR, double[] MA, double[] psi) {
        this(0.0, AR, MA, psi);
    }

    public ArmaxModel(double mu, double[] AR, double[] MA, double[] psi, double sigma) {
        super(mu, AR, 0, MA, psi, sigma);
    }

    public ArmaxModel(ArmaxModel that) {
        super(that);
    }

    public double armaxMeanNoIntercept(double[] arLags, double[] maLags, double[] exVar) {
        double a2 = this.AR != null ? FunctionOps.dotProduct(this.AR, arLags) : 0.0;
        double a3 = this.MA != null ? FunctionOps.dotProduct(this.MA, maLags) : 0.0;
        double a4 = this.psi != null ? FunctionOps.dotProduct(this.psi, exVar) : 0.0;
        return a2 + a3 + a4;
    }

    public ArmaxModel(double[] AR, double[] MA, double[] psi, double sigma) {
        this(0.0, AR, MA, psi, sigma);
    }

    public double armaxMean(double[] arLags, double[] maLags, double[] exVar) {
        double a2 = this.armaxMeanNoIntercept(arLags, maLags, exVar);
        return this.mu + a2;
    }
}

