/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.arma;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Riemann;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedProblem;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.arma.ArmaFitting;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arima.arma.ArmaModel;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class ConditionalSumOfSquares
implements ArmaFitting {
    private final int M;
    private final Estimators m;
    private final double H;

    public ArmaModel getFittedARMA() {
        return new ArmaModel(this.m.phi, this.m.theta, this.m.var);
    }

    public int nParams() {
        return this.m.p() + this.m.q() + 1;
    }

    private static RealScalarFunction H(final int a2, final int a3, double[] a4) {
        final int a5 = Math.max(a2, a3);
        final int a6 = a4.length;
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = R.rep(0.0, a5);
        dArrayArray[1] = a4;
        final double[] a7 = DoubleUtils.concat(dArrayArray);
        final int a8 = a7.length;
        return new RealScalarFunction(){

            public double evaluate(double ... params) {
                int a23;
                double d2;
                Estimators a32 = new Estimators(params, a2, a3);
                double a4 = a32.var;
                a4 = d2 > 0.0 ? a4 : 0.01;
                double[] a52 = new double[a8];
                int n = a23 = 0;
                while (n < a6) {
                    int a62;
                    int a72 = a5 + a23;
                    double[] a82 = new double[a2];
                    double[] a9 = new double[a3];
                    if (a2 > 0) {
                        int n2 = a62 = 0;
                        while (n2 < a2) {
                            a82[a62] = a7[a72 - a62 - 1];
                            n2 = ++a62;
                        }
                    }
                    if (a3 > 0) {
                        int n3 = a62 = 0;
                        while (n3 < a3) {
                            a9[a62] = a52[a72 - a62 - 1];
                            n3 = ++a62;
                        }
                    }
                    double a10 = FunctionOps.dotProduct(a32.phi, a82) + FunctionOps.dotProduct(a32.theta, a9);
                    a52[a72] = a7[a72] - a10;
                    n = ++a23;
                }
                double a22 = FunctionOps.dotProduct(a52, a52);
                double a11 = (double)a6 * Math.log(a4) + a22 / a4;
                return a11;
            }

            public int dimension4Range() {
                return 1;
            }
            {
                2 a22;
            }

            public int dimension4Domain() {
                return a3 + a2 + 1;
            }
        };
    }

    public double AICC() {
        double a2 = Math.log(this.H);
        return -2.0 * a2 + 2.0 * (double)this.nParams() * (double)this.M / (double)(this.M - this.nParams() - 1);
    }

    public ConditionalSumOfSquares(TimeSeries xt, int p2, int d2, int q) {
        this.M = xt.size();
        double[] a2 = xt.toArray();
        if (d2 > 0) {
            a2 = R.diff(a2, 1, d2);
        }
        RealScalarFunction a3 = ConditionalSumOfSquares.H(p2, q, a2);
        NelderMead a4 = new NelderMead();
        a4.solve(new UnconstrainedProblem(a3), Constant.EPSILON);
        double[] a5 = a4.search(new double[p2 + q + 1]);
        this.H = -1.0 * a3.evaluate(a5);
        this.m = new Estimators(a5, p2, q);
    }

    public ImmutableMatrix covariance() {
        int a2;
        int a3 = this.m.p();
        int a4 = this.m.q();
        int a5 = a3 + a4;
        Riemann a6 = new Riemann();
        DenseMatrix a7 = new DenseMatrix(a5, a5);
        int n = a2 = 1;
        while (n <= a5) {
            int n2 = a2;
            while (n2 <= a5) {
                int a8;
                final UnivariateRealFunction a9 = this.H(a2);
                final UnivariateRealFunction a10 = this.H(a8);
                UnivariateRealFunction a11 = new UnivariateRealFunction(){
                    {
                        1 a2;
                    }

                    public double evaluate(double x2) {
                        double a2 = a9.evaluate(x2);
                        double a3 = a10.evaluate(x2);
                        return a2 * a3;
                    }
                };
                double a12 = a6.integrate(a11, -Math.PI, Math.PI);
                a7.set(a2, a8, a12 /= Math.PI * 4);
                a7.set(a8, a2, a12);
                n2 = ++a8;
            }
            n = ++a2;
        }
        DenseMatrix a22 = new Inverse((Matrix)a7).scaled(1.0 / (double)this.M);
        return new ImmutableMatrix(a22);
    }

    private UnivariateRealFunction H(final int a2) {
        ConditionalSumOfSquares a3;
        final double[] a4 = a2 <= a3.m.p() ? a3.m.phi : a3.m.theta;
        return new UnivariateRealFunction(){
            {
                3 a22;
            }

            public double evaluate(double x2) {
                int a23;
                int a3;
                double a42 = 2.0 * Math.cos((double)a2 * x2);
                int n = a3 = 1;
                while (n <= a4.length) {
                    a42 -= 2.0 * a4[a3 - 1] * Math.cos((double)a2 * x2 - x2);
                    n = ++a3;
                }
                double a22 = 1.0;
                int n2 = a23 = 0;
                while (n2 < a4.length) {
                    a22 += a4[a23] * a4[a23];
                    a22 -= 2.0 * a4[a23] * Math.cos(x2);
                    n2 = ++a23;
                }
                int n3 = a23 = 1;
                while (n3 <= a4.length) {
                    int n4 = a23 + 1;
                    while (n4 <= a4.length) {
                        int a5;
                        a22 += 2.0 * a4[a23 - 1] * a4[a5 - 1] * Math.cos((double)(a23 - a5) * x2);
                        n4 = ++a5;
                    }
                    n3 = ++a23;
                }
                return a42 / a22;
            }
        };
    }

    public double AIC() {
        double a2 = Math.log(this.H);
        return -2.0 * a2 + 2.0 * (double)this.nParams();
    }

    public double var() {
        return this.m.var;
    }

    public ImmutableVector stderr() {
        int a2;
        ImmutableMatrix a3 = this.covariance();
        int a4 = this.m.p() + this.m.q();
        DenseVector a5 = new DenseVector(a4);
        int n = a2 = 1;
        while (n <= a4) {
            a5.set(a2, Math.sqrt(a3.get(a2, a2)));
            n = ++a2;
        }
        return new ImmutableVector(a5);
    }

    private static class Estimators {
        final double[] theta;
        final double[] phi;
        final double var;

        private Estimators(double[] a2, int a3, int a4) {
            Estimators a5;
            a5.phi = Arrays.copyOfRange(a2, 0, a3);
            a5.theta = Arrays.copyOfRange(a2, a3, a3 + a4);
            a5.var = a2[a3 + a4];
        }

        int q() {
            Estimators a2;
            return a2.theta.length;
        }

        int p() {
            Estimators a2;
            return a2.phi.length;
        }
    }
}

