/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedProblem;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch.GarchModel;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class Garch {
    private final double m;
    private GarchModel H;

    public final RealVectorFunction dLogLikelihood(final double[] e_t2, final int p2, final int q) {
        return new RealVectorFunction(){
            final int maxPQ;
            {
                4 a2;
                a2.maxPQ = Math.max(a2.p2, a2.q);
            }

            public Vector evaluate(double ... theta) {
                int a2;
                int a3;
                int a4;
                double[] a5 = Arrays.copyOfRange(theta, q + 1, 1 + p2 + q);
                GarchModel a6 = new GarchModel(theta[0], Arrays.copyOfRange(theta, 1, q + 1), a5);
                Vector[] a7 = new Vector[e_t2.length];
                int n = a4 = 0;
                while (n < this.maxPQ) {
                    a7[a4] = new DenseVector(1 + q + p2, 0.0);
                    a7[a4].set(1, 1.0);
                    n = ++a4;
                }
                double[] a22 = new double[e_t2.length];
                int n2 = a3 = 0;
                while (n2 < this.maxPQ) {
                    a22[a3] = Garch.this.m;
                    n2 = ++a3;
                }
                Vector a32 = new DenseVector(theta.length, 0.0);
                int n3 = a2 = this.maxPQ;
                while (n3 < e_t2.length) {
                    int a8;
                    double[] a9 = Arrays.copyOfRange(e_t2, a2 - q, a2);
                    DoubleUtils.reverse(a9);
                    double[] a10 = Arrays.copyOfRange(a22, a2 - p2, a2);
                    DoubleUtils.reverse(a10);
                    a22[a2] = a6.sigma2(a9, a10);
                    double[][] dArrayArray = new double[3][];
                    double[] dArray = new double[1];
                    dArray[0] = 1.0;
                    dArrayArray[0] = dArray;
                    dArrayArray[1] = a9;
                    dArrayArray[2] = a10;
                    a7[a2] = new DenseVector(DoubleUtils.concat(dArrayArray));
                    int n4 = a8 = 1;
                    while (n4 <= p2) {
                        Vector a11 = a7[a2 - a8].scaled(a5[a8 - 1]);
                        a7[a2] = a7[a2].add(a11);
                        n4 = ++a8;
                    }
                    Vector a42 = a7[a2].scaled(0.5 / a22[a2]);
                    a42 = a42.scaled(e_t2[a2] / a22[a2] - 1.0);
                    a32 = a32.add(a42);
                    n3 = ++a2;
                }
                a32 = a32.scaled(1.0 / (double)(e_t2.length - this.maxPQ));
                return a32;
            }

            public int dimension4Range() {
                return 1;
            }

            public int dimension4Domain() {
                return 1 + p2 + q;
            }
        };
    }

    public GarchModel model() {
        return this.H;
    }

    public Garch(TimeSeries xt, int p2, int q) {
        this(xt, p2, q, 300);
    }

    public Garch(TimeSeries xt, final int p2, final int q, int maxIterations) {
        double[] a2 = xt.toArray();
        this.m = new Variance(a2).value();
        final double[] a3 = DoubleUtils.foreach(a2, new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double x2) {
                return x2 * x2;
            }
        });
        RealScalarFunction a4 = new RealScalarFunction(){
            final RealScalarFunction L;

            public int dimension4Domain() {
                return this.L.dimension4Domain();
            }

            public double evaluate(double ... x2) {
                return -this.L.evaluate(x2);
            }
            {
                2 a2;
                a2.L = a2.Garch.this.logLikelihood(a2.a3, a2.p2, a2.q);
            }

            public int dimension4Range() {
                return this.L.dimension4Range();
            }
        };
        RealVectorFunction a5 = this.dLogLikelihood(a3, p2, q);
        NelderMead a6 = new NelderMead();
        a6.solve(new UnconstrainedProblem(a4), Constant.EPSILON);
        DenseVector a7 = new DenseVector(1 + q + p2, 0.05);
        a7.set(1, this.m);
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = a7;
        double[] a8 = a6.search(maxIterations, vectorArray).toArray();
        this.H = new GarchModel(a8[0], Arrays.copyOfRange(a8, 1, q + 1), Arrays.copyOfRange(a8, q + 1, 1 + q + p2));
    }

    public RealScalarFunction logLikelihood(final double[] e_t2, final int p2, final int q) {
        return new RealScalarFunction(){
            final int maxPQ;

            public double evaluate(double ... theta) {
                int a2;
                int a3;
                if (DoubleUtils.min(theta) < 0.0) {
                    return -1.7976931348623157E308;
                }
                GarchModel a4 = new GarchModel(theta[0], Arrays.copyOfRange(theta, 1, q + 1), Arrays.copyOfRange(theta, q + 1, 1 + p2 + q));
                double[] a5 = new double[e_t2.length];
                int n = a3 = 0;
                while (n < this.maxPQ) {
                    a5[a3] = Garch.this.m;
                    n = ++a3;
                }
                double a22 = 0.0;
                int n2 = a2 = this.maxPQ;
                while (n2 < e_t2.length) {
                    double[] a6 = Arrays.copyOfRange(e_t2, a2 - q, a2);
                    DoubleUtils.reverse(a6);
                    double[] a7 = Arrays.copyOfRange(a5, a2 - p2, a2);
                    DoubleUtils.reverse(a7);
                    a5[a2] = a4.sigma2(a6, a7);
                    double a8 = Garch.H(a5[a2], e_t2[a2]);
                    a22 += a8;
                    n2 = ++a2;
                }
                return a22 /= (double)(e_t2.length - this.maxPQ);
            }

            public int dimension4Range() {
                return 1;
            }
            {
                3 a2;
                a2.maxPQ = Math.max(a2.p2, a2.q);
            }

            public int dimension4Domain() {
                return 1 + p2 + q;
            }
        };
    }

    private static double H(double a2, double a3) {
        double a4 = Math.log(a2);
        a4 += a3 / a2;
        return a4 *= -0.5;
    }
}

