/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;

public class GarchModel {
    private double[] M;
    private double m;
    private double[] H;

    public GarchModel(double a0, double[] a2, double[] b2) {
        SuanShuUtils.assertArgument(a0 > 0.0, b.C("u%7*0e"));
        SuanShuUtils.assertArgument(DoubleUtils.min(a2) >= 0.0, b.C("i\u03a2l2(3e"));
        SuanShuUtils.assertArgument(DoubleUtils.min(b2) >= 0.0, b.C("i\u03a1l2(3e"));
        this.m = a0;
        this.M = a2 != null ? Arrays.copyOf(a2, a2.length) : null;
        this.H = b2 != null ? Arrays.copyOf(b2, b2.length) : null;
    }

    public double[] beta() {
        return this.H != null ? Arrays.copyOf(this.H, this.H.length) : null;
    }

    public double a0() {
        return this.m;
    }

    public double[] alpha() {
        return this.M != null ? Arrays.copyOf(this.M, this.M.length) : null;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    static {
        Package.getInstance(b.C("BDSE\u0006")).validate();
    }

    public GarchModel(GarchModel that) {
        this.m = that.m;
        this.M = that.M != null ? Arrays.copyOf(that.M, that.M.length) : null;
        this.H = that.H != null ? Arrays.copyOf(that.H, that.H.length) : null;
    }

    public double var() {
        double d2;
        int a2;
        double a3 = 1.0;
        int n = a2 = 0;
        while (n < this.q()) {
            a3 -= this.M[a2];
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < this.p()) {
            a3 -= this.H[a2];
            n2 = ++a2;
        }
        a3 = this.m / a3;
        SuanShuUtils.assertArgument(d2 > 0.0, b.C("|z`t}}v5ZULVQ4ie`woshwcad{`5\u03aao\u03bbh\u0015<SmRqBa\u001d\u03a5\u0002fLv\u0004%\u0019;U`C*\u000b5\u00064\u038dn\u039bi\n)5%-5xzdtq}z5ouh|dze0"));
        return a3;
    }

    public double sigma2(double[] e2, double[] sigma2_lag) {
        return this.m + FunctionOps.dotProduct(this.M, e2) + FunctionOps.dotProduct(this.H, sigma2_lag);
    }

    public int p() {
        return this.H != null ? this.H.length : 0;
    }

    public int q() {
        return this.M != null ? this.M.length : 0;
    }
}

