/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTimeTimeSeries<T extends Comparable<T>>
implements MultiVariateTimeSeries<T> {
    private final T[] m;
    private final Vector[] H;

    public T time(int index) {
        return this.m != null ? (T)this.m[index - 1] : null;
    }

    public String toString() {
        int a2;
        int a3 = this.size();
        StringBuilder a4 = new StringBuilder(a3);
        a4.append(b.C("."));
        int n = a2 = 0;
        while (n < a3) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.m != null ? this.m[a2].toString() + b.C("o") : b.C("");
            objectArray[1] = this.H[a2];
            a4.append(String.format(b.C("1f2g+_"), objectArray));
            n = ++a2;
        }
        a4.setCharAt(a4.length() - 2, '}');
        return a4.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTimeTimeSeries a2 = (GenericTimeTimeSeries)obj;
        if (!Arrays.deepEquals(this.m, a2.m)) {
            return false;
        }
        if (!Arrays.deepEquals(this.H, a2.H)) {
            return false;
        }
        return true;
    }

    public GenericTimeTimeSeries(T[] timestamps, Matrix values) {
        int a2;
        int a3 = values.nRows();
        SuanShuUtils.assertArgument(timestamps == null || timestamps.length == a3, b.C("{a{wtf2z{4htua\u007ff%uhq!zwxoq|f){l5A}[p\u0011gFtPdM5]{\u001a{J`\u0006x@`A="));
        this.m = timestamps != null ? (Comparable[])Arrays.copyOf(timestamps, timestamps.length) : null;
        this.H = new Vector[a3];
        int n = a2 = 0;
        while (n < a3) {
            this.H[a2] = values.getRow(a2 + 1);
            n = ++a2;
        }
    }

    @Override
    public int size() {
        return this.H.length;
    }

    public T[] timestamps() {
        return this.m != null ? (Comparable[])Arrays.copyOf(this.m, this.m.length) : null;
    }

    public GenericTimeTimeSeries(T[] timestamps, Vector[] values) {
        SuanShuUtils.assertArgument(timestamps == null || timestamps.length == values.length, b.C("{a{wtf2z{4htua\u007ff%uhq!zwxoq|f){l5A}[p\u0011gFtPdM5]{\u001a{J`\u0006x@`A="));
        this.m = timestamps != null ? (Comparable[])Arrays.copyOf(timestamps, timestamps.length) : null;
        this.H = Arrays.copyOf(values, values.length);
    }

    @Override
    public int dimension() {
        return this.H[0].size();
    }

    public GenericTimeTimeSeries<T> drop(int nItems) {
        Vector[] a2 = Arrays.copyOfRange(this.H, nItems, this.H.length);
        Comparable[] a3 = this.m != null ? (Comparable[])Arrays.copyOfRange(this.m, nItems, this.m.length) : null;
        return new GenericTimeTimeSeries(a3, a2);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 71 * a2 + Arrays.deepHashCode(this.m);
        a2 = 71 * a2 + Arrays.deepHashCode(this.H);
        return a2;
    }

    public Vector[] toArray() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    public Vector get(int index) {
        return this.H[index - 1];
    }

    public GenericTimeTimeSeries(T[] timestamps, double[][] values) {
        int a2;
        SuanShuUtils.assertArgument(timestamps == null || timestamps.length == values.length, b.C("{a{wtf2z{4htua\u007ff%uhq!zwxoq|f){l5A}[p\u0011gFtPdM5]{\u001a{J`\u0006x@`A="));
        this.m = timestamps != null ? (Comparable[])Arrays.copyOf(timestamps, timestamps.length) : null;
        this.H = new Vector[values.length];
        int n = a2 = 0;
        while (n < values.length) {
            this.H[a2] = new DenseVector(values[a2]);
            n = ++a2;
        }
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    @Override
    public Matrix toMatrix() {
        return CreateMatrix.rbind(this.H);
    }

    public GenericTimeTimeSeries<T> diff(int d2) {
        double[][] a2 = MatrixUtils.to2DArray(CreateMatrix.rbind(this.H));
        double[][] a3 = R.diff(a2, 1, d2);
        Comparable[] a4 = this.m != null ? (Comparable[])Arrays.copyOfRange(this.m, d2, this.m.length) : null;
        return new GenericTimeTimeSeries(a4, a3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    extends MultiVariateTimeSeries.Iterator<MultiVariateTimeSeries.Entry<T>> {
        @Override
        public Vector nextValue() {
            return GenericTimeTimeSeries.this.get(++this.pos);
        }

        @Override
        public MultiVariateTimeSeries.Entry<T> next() {
            ++this.pos;
            return new MultiVariateTimeSeries.Entry(GenericTimeTimeSeries.this.time(this.pos), GenericTimeTimeSeries.this.get(this.pos));
        }

        private Iterator(MultiVariateTimeSeries<?> a2) {
            Iterator a3;
            super(a2);
        }
    }
}

