/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class SimpleMultiVariateTimeSeries
implements MultiVariateTimeSeries {
    private final DenseMatrix H;

    public int hashCode() {
        int a2 = 7;
        a2 = 79 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    public Matrix toMatrix() {
        return new DenseMatrix(this.H);
    }

    public Vector get(int t2) {
        return this.H.getRow(t2);
    }

    public SimpleMultiVariateTimeSeries(double[] ... values) {
        this.H = new DenseMatrix(values);
    }

    public String toString() {
        return this.H.toString();
    }

    public SimpleMultiVariateTimeSeries diff(int d2) {
        return new SimpleMultiVariateTimeSeries(R.diff(MatrixUtils.to2DArray(this.H), 1, d2));
    }

    public SimpleMultiVariateTimeSeries(Matrix values) {
        this.H = new DenseMatrix(values);
    }

    public SimpleMultiVariateTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }

    public int dimension() {
        return this.H.nCols();
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public SimpleMultiVariateTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    public SimpleMultiVariateTimeSeries(TimeSeries ts) {
        this(new DenseMatrix(ts.toArray(), ts.size(), 1));
    }

    public SimpleMultiVariateTimeSeries(Vector ... values) {
        this.H = new DenseMatrix(CreateMatrix.rbind(values));
    }

    public int size() {
        return this.H.nRows();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMultiVariateTimeSeries a2 = (SimpleMultiVariateTimeSeries)obj;
        if (!(this.H == a2.H || this.H != null && this.H.equals(a2.H))) {
            return false;
        }
        return true;
    }

    public SimpleMultiVariateTimeSeries lag(int nLags, int length) {
        int a2;
        SuanShuUtils.assertArgument(nLags >= 0, b.C("zYvsc5-)<e"));
        int a3 = this.size() - nLags - length + 1;
        SuanShuUtils.assertArgument(a3 >= 1, b.C("yuqrtp2fxfwpj4vpksr}!}q5y{a5e{d2"));
        Vector[] a4 = new Vector[length];
        int n = a2 = a3;
        while (n <= this.size() - nLags) {
            a4[a2 - a3] = this.H.getRow(a2);
            n = ++a2;
        }
        return new SimpleMultiVariateTimeSeries(CreateMatrix.rbind(a4));
    }

    public class Iterator
    extends MultiVariateTimeSeries.Iterator {
        public MultiVariateTimeSeries.Entry next() {
            return new MultiVariateTimeSeries.Entry(++this.pos, SimpleMultiVariateTimeSeries.this.H.getRow(this.pos));
        }

        public Vector nextValue() {
            return SimpleMultiVariateTimeSeries.this.H.getRow(++this.pos);
        }

        private Iterator(SimpleMultiVariateTimeSeries a2) {
            Iterator a3;
            super(a2);
        }
    }
}

