/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.univariate;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.univariate.TimeSeries;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTimeTimeSeries<T extends Comparable<T>>
implements TimeSeries<T> {
    private final T[] m;
    private final double[] H;

    public GenericTimeTimeSeries<T> drop(int nItems) {
        double[] a2 = Arrays.copyOfRange(this.H, nItems, this.H.length);
        Comparable[] a3 = this.m != null ? (Comparable[])Arrays.copyOfRange(this.m, nItems, this.m.length) : null;
        return new GenericTimeTimeSeries(a3, a2);
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    public T time(int index) {
        return this.m != null ? (T)this.m[index - 1] : null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTimeTimeSeries a2 = (GenericTimeTimeSeries)obj;
        if (!Arrays.deepEquals(this.m, a2.m)) {
            return false;
        }
        if (!Arrays.equals(this.H, a2.H)) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 59 * a2 + Arrays.deepHashCode(this.m);
        a2 = 59 * a2 + Arrays.hashCode(this.H);
        return a2;
    }

    public GenericTimeTimeSeries(T[] timestamps, double[] values) {
        SuanShuUtils.assertArgument(timestamps == null || timestamps.length == values.length, b.C("{a{wtf2z{4htua\u007ff%uhq!zwxoq|f){l5A}[p\u0011gFtPdM5]{\u001a{J`\u0006x@`A="));
        this.H = Arrays.copyOf(values, values.length);
        this.m = timestamps != null ? (Comparable[])Arrays.copyOf(timestamps, timestamps.length) : null;
    }

    public String toString() {
        int a2;
        int a3 = this.size();
        StringBuilder a4 = new StringBuilder(a3);
        a4.append(b.C("\u000e"));
        int n = a2 = 0;
        while (n < a3) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.m != null ? this.m[a2].toString() + b.C("o") : b.C("");
            objectArray[1] = this.H[a2];
            a4.append(String.format(b.C("1f2r+u"), objectArray));
            n = ++a2;
        }
        a4.append(b.C("\b"));
        return a4.toString();
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public T[] timestamps() {
        return this.m != null ? (Comparable[])Arrays.copyOf(this.m, this.m.length) : null;
    }

    public GenericTimeTimeSeries<T> diff(int d2) {
        double[] a2 = R.diff(this.H, 1, d2);
        Comparable[] a3 = this.m != null ? (Comparable[])Arrays.copyOfRange(this.m, d2, this.m.length) : null;
        return new GenericTimeTimeSeries(a3, a2);
    }

    public double get(int index) {
        return this.H[index - 1];
    }

    @Override
    public int size() {
        return this.H.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    extends TimeSeries.Iterator<TimeSeries.Entry<T>> {
        private Iterator(TimeSeries<?> a2) {
            Iterator a3;
            super(a2);
        }

        @Override
        public double nextValue() {
            return GenericTimeTimeSeries.this.get(++this.pos);
        }

        @Override
        public TimeSeries.Entry<T> next() {
            ++this.pos;
            return new TimeSeries.Entry(GenericTimeTimeSeries.this.time(this.pos), GenericTimeTimeSeries.this.get(this.pos));
        }
    }
}

