/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.univariate.realtime;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import java.util.Arrays;

public class SimpleTimeSeries
implements TimeSeries {
    private final double[] H;

    public double[] toArray() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    public String toString() {
        int a2;
        int a3 = 20;
        StringBuilder a4 = new StringBuilder();
        Object[] objectArray = new Object[1];
        objectArray[0] = this.H.length;
        a4.append(String.format(b.C("yqxre|2(=1z_"), objectArray));
        int n = a2 = 1;
        while (n <= this.H.length) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a2;
            a4.append(String.format(b.C("O0s8Mu"), objectArray2));
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = this.H[a2 - 1];
            a4.append(String.format(b.C("0r:u"), objectArray3));
            if (a2 % 20 == 0) {
                a4.append("\n");
            }
            n = ++a2;
        }
        return a4.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTimeSeries a2 = (SimpleTimeSeries)obj;
        if (!Arrays.equals(this.H, a2.H)) {
            return false;
        }
        return true;
    }

    public SimpleTimeSeries lag(int nLags, int length) {
        int a2;
        SuanShuUtils.assertArgument(nLags >= 0, b.C("zYvsc5-)<e"));
        int a3 = this.size() - nLags - length + 1;
        SuanShuUtils.assertArgument(a3 >= 1, b.C("yuqrtp2fxfwpj4vpksr}!}q5y{a5e{d2"));
        double[] a4 = new double[length];
        int n = a2 = a3;
        while (n <= this.size() - nLags) {
            a4[a2 - a3] = this.H[a2 - 1];
            n = ++a2;
        }
        return new SimpleTimeSeries(a4);
    }

    public SimpleTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public double get(int t2) {
        return this.H[t2 - 1];
    }

    public SimpleTimeSeries diff(int d2) {
        return new SimpleTimeSeries(R.diff(this.H, 1, d2));
    }

    public SimpleTimeSeries(double[] values) {
        this.H = Arrays.copyOf(values, values.length);
    }

    public int size() {
        return this.H.length;
    }

    public SimpleTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 79 * a2 + Arrays.hashCode(this.H);
        return a2;
    }

    public class Iterator
    extends TimeSeries.Iterator {
        public double nextValue() {
            int n = this.pos;
            this.pos = n + 1;
            return SimpleTimeSeries.this.H[n];
        }

        public TimeSeries.Entry next() {
            return new TimeSeries.Entry(++this.pos, SimpleTimeSeries.this.H[this.pos - 1]);
        }

        private Iterator(SimpleTimeSeries a2) {
            Iterator a3;
            super(a2);
        }
    }
}

