/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles;

import com.numericalmethod.suanshu.vector.doubles.Vector;

public class IsVector {
    private IsVector() {
        IsVector a2;
    }

    public static void validIndex(Vector v, int index) {
        if (index < 1 || index > v.size()) {
            throw new VectorAccessException(v.size(), index);
        }
    }

    public static void equalSize(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            throw new SizeMismatch(v1.size(), v2.size());
        }
    }

    public static class VectorAccessException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VectorAccessException(int size, int index) {
            Object[] objectArray = new Object[2];
            objectArray[0] = size;
            objectArray[1] = index;
            super(String.format(b.C("f}~$bn#{`fel%S73<lG)tfzli22,1"), objectArray));
        }

        public VectorAccessException(String msg) {
            super(msg);
        }
    }

    public static class SizeMismatch
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SizeMismatch(int size1, int size2) {
            Object[] objectArray = new Object[2];
            objectArray[0] = size1;
            objectArray[1] = size2;
            super(String.format(b.C("cqua~fa5y{>{v`:}dbc5u|g5~ucp)gcoP.\u00160U4S{Y4\u001b1"), objectArray));
        }
    }
}

