/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles.dense;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.IsVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.VectorImpl;
import java.util.Arrays;

public class DenseVector
extends VectorImpl {
    public final int length;
    private double[] H;

    public Vector add(Vector that) {
        if (that instanceof DenseVector) {
            return this.add((DenseVector)that);
        }
        return super.add(that);
    }

    public DenseVector deepCopy() {
        return new DenseVector(this);
    }

    public DenseVector(int length, double value) {
        int a2;
        this.length = length;
        this.H = new double[this.length];
        int n = a2 = 0;
        while (n < this.H.length) {
            this.H[a2] = value;
            n = ++a2;
        }
    }

    public double[] toArray() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    public DenseVector(Matrix A) {
        SuanShuUtils.assertArgument(A.nCols() == 1, b.C("L,cxzx*o`,g-bcnxpb>`xxhd-"));
        this.H = A.getColumn(1).toArray();
        this.length = this.H.length;
    }

    public DenseVector minus(DenseVector that) {
        int a2;
        IsVector.equalSize(this, that);
        DenseVector a3 = new DenseVector(this.length);
        int n = a2 = 0;
        while (n < this.length) {
            a3.H[a2] = this.H[a2] - that.H[a2];
            n = ++a2;
        }
        return a3;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(b.C("\u000e"));
        int n = a2 = 0;
        while (n < this.length) {
            Object[] objectArray = new Object[1];
            objectArray[0] = this.H[a2];
            a3.append(String.format(b.C("0r:u"), objectArray));
            n = ++a2;
        }
        a3.setCharAt(a3.length() - 2, ']');
        return a3.toString();
    }

    public DenseVector multiply(DenseVector v) {
        int a2;
        IsVector.equalSize(this, v);
        double[] a3 = new double[this.length];
        int n = a2 = 0;
        while (n < this.length) {
            a3[a2] = this.get(a2 + 1) * v.get(a2 + 1);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    public Vector pow(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.H, new UnivariateRealFunction(){
            {
                3 a2;
            }

            public double evaluate(double x2) {
                return Math.pow(x2, scalar);
            }
        });
        return new DenseVector(a2);
    }

    public static DenseVector as(Vector v) {
        if (v instanceof DenseVector) {
            return (DenseVector)v;
        }
        return new DenseVector(v);
    }

    private double H(DenseVector a2) {
        DenseVector a3;
        IsVector.equalSize(a3, a2);
        return FunctionOps.dotProduct(a3.H, a2.H);
    }

    public DenseVector(int length) {
        this.length = length;
        this.H = new double[this.length];
    }

    public double get(int index) {
        IsVector.validIndex(this, index);
        return this.H[index - 1];
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 79 * a2 + this.length;
        a2 = 79 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    public Vector scaled(double scalar) {
        int a2;
        DenseVector a3 = new DenseVector(this.length);
        int n = a2 = 0;
        while (n < this.length) {
            a3.H[a2] = this.H[a2] * scalar;
            n = ++a2;
        }
        return a3;
    }

    public double norm(int p2) {
        int a2;
        if (p2 == Integer.MAX_VALUE) {
            return DoubleUtils.max(DoubleUtils.abs(this.toArray()));
        }
        if (p2 == Integer.MIN_VALUE) {
            return DoubleUtils.min(DoubleUtils.abs(this.toArray()));
        }
        double a3 = 0.0;
        int n = a2 = 0;
        while (n < this.length) {
            a3 += Math.pow(this.H[a2], p2);
            n = ++a2;
        }
        a3 = Math.pow(a3, 1.0 / (double)p2);
        return a3;
    }

    public Vector minus(Vector that) {
        if (that instanceof DenseVector) {
            return this.minus((DenseVector)that);
        }
        return super.minus(that);
    }

    static {
        Package.getInstance(b.C("SQAX\u0016")).validate();
    }

    public DenseVector(DenseVector vector) {
        this.length = vector.length;
        this.H = Arrays.copyOf(vector.H, this.length);
    }

    public DenseVector divide(DenseVector v) {
        int a2;
        IsVector.equalSize(this, v);
        double[] a3 = new double[this.length];
        int n = a2 = 0;
        while (n < this.length) {
            a3[a2] = this.get(a2 + 1) / v.get(a2 + 1);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    public void set(int from, DenseVector replacement) {
        int a2;
        if (from + replacement.length - 1 > this.length) {
            throw new IllegalArgumentException(b.C("uhg!wevmhcolhnz!gequzr6m|n}uu mu@rVhKg\u0006g[oG!\nf\\n\\'\u0012dMcSd]s\u001auUe\u001ensiehkaj!\u007feiubr.mtnuu="));
        }
        int a3 = from;
        int n = a2 = 1;
        while (n <= replacement.length) {
            this.set(a3, replacement.get(a2));
            ++a3;
            n = ++a2;
        }
    }

    public Vector add(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.H, new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double x2) {
                return x2 + scalar;
            }
        });
        return new DenseVector(a2);
    }

    public Vector multiply(Vector v) {
        if (v instanceof DenseVector) {
            return this.multiply((DenseVector)v);
        }
        return super.multiply(v);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector a2 = (Vector)obj;
        if (!AreMatrices.equal(this, a2, 0.0)) {
            return false;
        }
        return true;
    }

    public Vector divide(Vector that) {
        if (that instanceof DenseVector) {
            return this.divide((DenseVector)that);
        }
        return super.divide(that);
    }

    public DenseVector add(DenseVector that) {
        int a2;
        IsVector.equalSize(this, that);
        DenseVector a3 = new DenseVector(this.length);
        int n = a2 = 0;
        while (n < this.length) {
            a3.H[a2] = this.H[a2] + that.H[a2];
            n = ++a2;
        }
        return a3;
    }

    public double innerProduct(Vector that) {
        if (that instanceof DenseVector) {
            return this.H((DenseVector)that);
        }
        return super.innerProduct(that);
    }

    public DenseVector(Vector v) {
        this.length = v.size();
        this.H = v.toArray();
    }

    public void set(int index, double value) {
        IsVector.validIndex(this, index);
        this.H[index - 1] = value;
    }

    public DenseVector ZERO() {
        return new DenseVector(this.length);
    }

    public DenseVector(double ... data) {
        this.length = data.length;
        this.H = data;
    }

    public Vector minus(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.H, new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double x2) {
                return x2 - scalar;
            }
        });
        return new DenseVector(a2);
    }
}

