/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles.dense;

import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.vector.doubles.IsVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

abstract class VectorImpl
implements Vector {
    public Vector add(Vector that) {
        int a2;
        IsVector.equalSize(this, that);
        int a3 = this.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, this.get(a2) + that.get(a2));
            n = ++a2;
        }
        return a4;
    }

    public Vector scaled(Real scalar) {
        return this.scaled(scalar.doubleValue());
    }

    public Vector scaled(double scalar) {
        int a2;
        int a3 = this.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, scalar * this.get(a2));
            n = ++a2;
        }
        return a4;
    }

    public Vector divide(Vector that) {
        int a2;
        IsVector.equalSize(this, that);
        int a3 = this.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, this.get(a2) / that.get(a2));
            n = ++a2;
        }
        return a4;
    }

    public double angle(Vector that) {
        double a2 = this.innerProduct(that);
        a2 /= this.norm();
        a2 /= that.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    public Vector opposite() {
        return this.scaled(-1.0);
    }

    public Vector minus(Vector that) {
        int a2;
        IsVector.equalSize(this, that);
        int a3 = this.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, this.get(a2) - that.get(a2));
            n = ++a2;
        }
        return a4;
    }

    VectorImpl() {
        VectorImpl a2;
    }

    public Vector multiply(Vector that) {
        int a2;
        IsVector.equalSize(this, that);
        int a3 = this.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, this.get(a2) * that.get(a2));
            n = ++a2;
        }
        return a4;
    }

    public double innerProduct(Vector that) {
        int a2;
        IsVector.equalSize(this, that);
        int a3 = this.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += this.get(a2) * that.get(a2);
            n = ++a2;
        }
        return a4;
    }

    public double norm() {
        return this.norm(2);
    }

    public Vector pow(double scalar) {
        int a2;
        int a3 = this.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            a4.set(a2, Math.pow(this.get(a2), scalar));
            n = ++a2;
        }
        return a4;
    }
}

