/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles.dense.operation;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.HouseholderReflection;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.OLSSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class VectorSpace {
    public final double epsilon;
    private VectorList M = new VectorList();
    private int m;
    private VectorList H = new VectorList();

    @Deprecated
    public Vector linearSpan(double ... d2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    @Deprecated
    public boolean isInKernel(Vector b2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public VectorSpace(VectorList elements) {
        this(CreateMatrix.cbind(elements));
    }

    public VectorList complement() {
        return new VectorList(this.H);
    }

    public VectorSpace(Vector ... elements) {
        this(CreateMatrix.cbind(elements));
    }

    public int rank() {
        return this.m;
    }

    private void H(Matrix a2) {
        Vector a3;
        int a4;
        VectorSpace a5;
        HouseholderReflection a6 = new HouseholderReflection(a2, a5.epsilon);
        Matrix a7 = a6.squareQ();
        a5.m = a6.rank();
        int n = a4 = 1;
        while (n <= a5.m) {
            a3 = a7.getColumn(a4);
            a3 = a3.scaled(1.0 / a3.norm());
            a5.M.add(a3);
            n = ++a4;
        }
        int n2 = a4 = a5.m + 1;
        while (n2 <= a7.nCols()) {
            a3 = a7.getColumn(a4);
            a3 = a3.scaled(1.0 / a3.norm());
            a5.H.add(a3);
            n2 = ++a4;
        }
    }

    public VectorSpace(VectorList elements, double epsilon) {
        this(CreateMatrix.cbind(elements), epsilon);
    }

    public VectorSpace(double epsilon, Vector ... elements) {
        this(CreateMatrix.cbind(elements), epsilon);
    }

    public VectorSpace(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(A)));
    }

    public Vector spanningCoefficients(Vector b2) {
        Vector a2 = null;
        try {
            DenseMatrix a3 = CreateMatrix.cbind(this.M);
            a2 = new OLSSolver(a3, OLSSolver.Method.QR, this.epsilon).solve(b2);
            Vector a4 = a3.multiply(a2);
            if (!AreMatrices.equal(a4, b2, this.epsilon)) {
                a2 = null;
            }
        }
        catch (Exception a5) {
            a2 = null;
        }
        return a2;
    }

    public VectorList basis() {
        return new VectorList(this.M);
    }

    public VectorSpace(Matrix A, double epsilon) {
        this.epsilon = epsilon;
        this.H(A);
    }

    public boolean isSpanned(Vector b2) {
        return this.spanningCoefficients(b2) != null;
    }
}

