Attribute VB_Name = "TextEditFileSaveOpen"
Option Explicit
' API's and Const to load large files
Private Declare Function SendMessage Lib "user32" _
  Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, _
  ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetWindowTextLength Lib "user32" _
  Alias "GetWindowTextLengthA" (ByVal hwnd As Long) As Long
Private Const WM_SETTEXT = &HC
Private Const WM_GETTEXT = &HD
Private Const WM_GETTEXTLENGTH = &HE

Sub FileOpen()
  Dim TempText As String
  Dim FileNum As Integer
  Dim iret As Long
  Dim Filename As String
  Dim Title As String
  Dim Message As String
  Dim Style As String
  Dim Response As String
  If TextWindow.TextDisplayCopy.Text <> TextWindow.TextDisplay.Text Then
    Title = "Text Edit Warning"
    Message = "Current File has Changed - Replace current File with New ?"
    Style = vbYesNo + vbCritical + vbDefaultButton2
    Response = MsgBox(Message, Style, Title)
    If Response <> vbYes Then
      Exit Sub
    End If
  End If
  On Error Resume Next
  TextWindow.CommonDialog1.CancelError = True
  TextWindow.CommonDialog1.Filter = "Text Files (*.txt)|*.txt|HTML Files (*.html)|*.html|All Files (*.*)|*.*"
  TextWindow.CommonDialog1.FilterIndex = 1
  TextWindow.CommonDialog1.Filename = ""
  TextWindow.CommonDialog1.ShowOpen
  If Err = 32755 Then
    Exit Sub
  End If
  Filename = TextWindow.CommonDialog1.Filename
  On Error GoTo Errhandler
  FileNum = FreeFile
  Open Filename For Input As #FileNum
  If Err Then
    MsgBox "Can't open file: " + Filename
    Exit Sub
  End If
  TempText = StrConv(InputB(LOF(FileNum), FileNum), vbUnicode)
  DoEvents
  TextWindow.TextDisplay.Text = ""
  iret = SendMessage(TextWindow.TextDisplay.hwnd, WM_SETTEXT, 0&, ByVal TempText)
  Debug.Print "WM_SETTEXT: " & iret
  iret = SendMessage(TextWindow.TextDisplay.hwnd, WM_GETTEXTLENGTH, 0&, ByVal 0&)
  Debug.Print "WM_GETTEXTLENGTH: " & iret
  TempText = ""
  Close #FileNum
  CopyTextBox
  Exit Sub
Errhandler:
  Close #FileNum
  MsgBox "Error:" & Str(Err) & " - " & Error$, vbCritical, "Textbox Error"
  Exit Sub
End Sub

Sub CopyTextBox()
  Dim iret As Long
  On Error GoTo Errhandler
  DoEvents
  TextWindow.TextDisplayCopy.Text = ""
  iret = SendMessage(TextWindow.TextDisplayCopy.hwnd, WM_SETTEXT, 0&, ByVal TextWindow.TextDisplay.Text)
  Debug.Print "WM_SETTEXT: " & iret
  iret = SendMessage(TextWindow.TextDisplayCopy.hwnd, WM_GETTEXTLENGTH, 0&, ByVal 0&)
  Debug.Print "WM_GETTEXTLENGTH: " & iret
  Exit Sub
Errhandler:
  MsgBox "Error:" & Str(Err) & " - " & Error$, vbCritical, "Textbox Error"
  Exit Sub
End Sub

Sub SaveFileProc()
  Dim CurrentTextFile As String
  Dim ThisTime As String
  On Error Resume Next
  TextWindow.CommonDialog1.Filter = "Text Files (*.txt)|*.txt|HTML Files (*.html)|*.html|All Files (*.*)|*.*"
  TextWindow.CommonDialog1.ShowSave
  If Err = 32755 Then
    Exit Sub
  End If
  If TextWindow.CommonDialog1.Filename <> "" Then
    CurrentTextFile = TextWindow.CommonDialog1.Filename
    Open CurrentTextFile For Output As #2
    Print #2, TextWindow.TextDisplay.Text
    Close #2
    ThisTime = Format(Time(), "hh:mm AM/PM")
    TextWindow.Caption = "Text Edit " + TextWindow.CommonDialog1.Filename + " - Saved " + ThisTime
  End If
  CopyTextBox
End Sub
