/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import java.awt.geom.Rectangle2D;

public class MutableRectangle
extends SimpleObservable {
    private double x;
    private double y;
    private double width;
    private double height;
    private Rectangle2D.Double defaultValue;

    public MutableRectangle(Rectangle2D.Double double_) {
        this(double_.getX(), double_.getY(), double_.getWidth(), double_.getHeight());
    }

    public MutableRectangle(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.defaultValue = new Rectangle2D.Double(d, d2, d3, d4);
    }

    public void reset() {
        this.x = this.defaultValue.getX();
        this.y = this.defaultValue.getY();
        this.width = this.defaultValue.getWidth();
        this.height = this.defaultValue.getHeight();
        this.notifyObservers();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getMinY() {
        return this.y;
    }

    public void setVerticalRange(double d, double d2) {
        assert (d2 > d);
        this.y = d;
        this.height = d2 - d;
        this.notifyObservers();
    }

    public Rectangle2D.Double toRectangle2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMinX() {
        return this.x;
    }

    public void setHorizontalRange(double d, double d2) {
        assert (d2 > d);
        if (this.x != d || this.width != d2 - d) {
            this.x = d;
            this.width = d2 - d;
            this.notifyObservers();
        }
    }
}

