/*
 * Decompiled with CFR 0.152.
 */
package bmantunes.tibcheck;

import bmantunes.tibcheck.bw.BwProcess;
import bmantunes.tibcheck.bw.BwProject;
import bmantunes.tibcheck.utils.DesignTimeLibs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GenericBWProcessChecker {
    private static final String[] defaultIgnoredNamespaces = new String[]{"http://www.w3.org/1999/XSL/Transform", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/wsdl/"};
    private static final String[] defaultIgnoredNamespacePrefixes = new String[]{"java://", "http://xmlns.tibco.com/", "http://www.w3.org/2001/XMLSchema", "http://www.tibco.com/", "http://schemas.tibco.com/", "www.tibco.com/"};
    private boolean ignoreDefaultNamespaces = true;
    private final String cfgFilePath;
    private BwProject project;

    public GenericBWProcessChecker(String cfgFilePath) {
        this.cfgFilePath = cfgFilePath;
        this.project = new BwProject();
    }

    private static List<String> getProcessFileList(File projectDir) throws FileNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        for (File currentFileOrDir : Arrays.asList(projectDir.listFiles())) {
            if (currentFileOrDir.isFile() && currentFileOrDir.getName().endsWith(".process")) {
                result.add(currentFileOrDir.getAbsolutePath());
            }
            if (!currentFileOrDir.isDirectory()) continue;
            List<String> childList = GenericBWProcessChecker.getProcessFileList(currentFileOrDir);
            result.addAll(childList);
        }
        return result;
    }

    private boolean checkIgnoreNamespace(String namespace) {
        if (this.ignoreDefaultNamespaces) {
            if (Arrays.asList(defaultIgnoredNamespaces).contains(namespace)) {
                return true;
            }
            for (String prefix : defaultIgnoredNamespacePrefixes) {
                if (!namespace.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> checkProcessFile_old(String processFilePath, String ProjectDirString) throws IOException {
        BufferedReader br = null;
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(processFilePath), "UTF-8");
            br = new BufferedReader(isr, 8192);
            ArrayList<String> errorList = new ArrayList<String>();
            HashMap<String, String> unusedNamespaces = new HashMap<String, String>();
            HashMap<String, String> allNamespaces = new HashMap<String, String>();
            HashMap<String, String> fileList = new HashMap<String, String>();
            String line = br.readLine();
            while (line != null) {
                String schemaLocation;
                String namespace;
                if (line.contains("<xsd:import namespace=") || line.contains("<xs:import xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" namespace=\"")) {
                    if (!line.contains("schemaLocation=\"")) {
                        namespace = line.substring(line.indexOf("namespace=\"") + 11, line.lastIndexOf("\""));
                        errorList.add("ERROR! Imported namespace does not have associated file location: " + namespace);
                    } else {
                        schemaLocation = line.substring(line.indexOf("schemaLocation=\"") + 16, line.lastIndexOf("\""));
                        if (schemaLocation.startsWith("/")) {
                            schemaLocation = schemaLocation.replaceFirst("/", "");
                        }
                        String namespace2 = line.substring(line.indexOf("namespace=\"") + 11, line.indexOf("schemaLocation=\"") - 2);
                        if (!new File(ProjectDirString + "/" + schemaLocation).exists()) {
                            boolean foundFile = false;
                            if (this.project.getDesignTimeLibs() != null && this.project.getDesignTimeLibs().getDesigntimelibContents() != null) {
                                for (HashSet<String> projlibFiles : this.project.getDesignTimeLibs().getDesigntimelibContents().values()) {
                                    if (!projlibFiles.contains(schemaLocation)) continue;
                                    foundFile = true;
                                    fileList.put(schemaLocation, namespace2);
                                }
                            }
                            if (!foundFile) {
                                errorList.add("ERROR! File Not Found: " + schemaLocation);
                            }
                        } else if (!allNamespaces.containsValue(namespace2) && !namespace2.contains("tibco.com/")) {
                            errorList.add("WARNING! File does not have associated prefix: " + schemaLocation);
                        } else {
                            fileList.put(schemaLocation, namespace2);
                        }
                    }
                } else if (line.contains("<wsdl:import namespace=")) {
                    if (!line.contains("location=\"")) {
                        namespace = line.substring(line.indexOf("namespace=\"") + 11, line.lastIndexOf("\""));
                        errorList.add("ERROR! Imported namespace does not have associated file location: " + namespace);
                    } else {
                        schemaLocation = line.substring(line.indexOf("location=\"") + 10, line.lastIndexOf("\""));
                        if (schemaLocation.startsWith("/")) {
                            schemaLocation = schemaLocation.replaceFirst("/", "");
                        }
                        String namespace3 = line.substring(line.indexOf("namespace=\"") + 11, line.indexOf("location=\"") - 2);
                        if (!new File(ProjectDirString + "/" + schemaLocation).exists()) {
                            errorList.add("ERROR! File Not Found: " + schemaLocation);
                        } else if (!allNamespaces.containsValue(namespace3) && !namespace3.contains("tibco.com/")) {
                            errorList.add("WARNING! File does not have associated prefix: " + schemaLocation);
                        } else {
                            fileList.put(schemaLocation, namespace3);
                        }
                    }
                } else if (line.contains("<pd:ProcessDefinition ")) {
                    String[] splitLine;
                    for (String token : splitLine = line.split("\" ")) {
                        String namespace4;
                        if (!token.startsWith("xmlns:") || this.checkIgnoreNamespace(namespace4 = token.lastIndexOf("\"") == token.indexOf("\"") ? token.substring(token.indexOf("\"") + 1) : token.substring(token.indexOf("\"") + 1, token.lastIndexOf("\"")))) continue;
                        allNamespaces.put(token.substring(6, token.indexOf("=")), namespace4);
                        unusedNamespaces.put(token.substring(6, token.indexOf("=")), namespace4);
                    }
                } else if (!unusedNamespaces.isEmpty()) {
                    String[] prefixList = new String[]{""};
                    prefixList = unusedNamespaces.keySet().toArray(prefixList);
                    for (int i = 0; i < prefixList.length; ++i) {
                        if (!line.contains(prefixList[i] + ":")) continue;
                        unusedNamespaces.remove(prefixList[i]);
                    }
                }
                line = br.readLine();
            }
            if (!unusedNamespaces.isEmpty()) {
                for (Map.Entry prefix : unusedNamespaces.entrySet()) {
                    errorList.add("WARNING! UnusedPrefix: " + (String)prefix.getKey() + " => " + (String)prefix.getValue());
                }
            }
            for (String namespace : allNamespaces.values()) {
                if (fileList.containsValue(namespace) || unusedNamespaces.containsValue(namespace)) continue;
                errorList.add("POSSIBLE ERROR! Namespace does not have associated file: " + namespace);
            }
            ArrayList<String> arrayList = errorList;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> checkProcessFile(BwProcess bwProcess, String ProjectDirString) throws IOException {
        BufferedReader br = null;
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(bwProcess.getFileLocation()), "UTF-8");
            br = new BufferedReader(isr, 8192);
            ArrayList<String> errorList = new ArrayList<String>();
            HashMap<String, String> unusedNamespaces = new HashMap<String, String>(bwProcess.getNamespacePrefixes());
            ArrayList<String> keyList = new ArrayList<String>(unusedNamespaces.keySet());
            for (String key : keyList) {
                if (!this.checkIgnoreNamespace(unusedNamespaces.get(key))) continue;
                unusedNamespaces.remove(key);
            }
            for (String namespace : bwProcess.getErrorImportWithoutLocation()) {
                if (this.checkIgnoreNamespace(namespace)) continue;
                errorList.add("ERROR! Imported namespace does not have associated file location: " + namespace);
                unusedNamespaces.remove(namespace);
            }
            for (String schemaLocation : bwProcess.getImportedSchemaFiles().keySet()) {
                if (new File(ProjectDirString + schemaLocation).exists()) continue;
                boolean foundFile = false;
                if (this.project.getDesignTimeLibs() != null && this.project.getDesignTimeLibs().getDesigntimelibContents() != null) {
                    for (HashSet hashSet : this.project.getDesignTimeLibs().getDesigntimelibContents().values()) {
                        if (!hashSet.contains(schemaLocation.substring(1))) continue;
                        foundFile = true;
                    }
                }
                if (foundFile) continue;
                errorList.add("ERROR! File Not Found: " + schemaLocation);
            }
            String line = br.readLine();
            boolean passedHeader = false;
            while (line != null) {
                if (!passedHeader) {
                    if (!(line.contains("<xsd:import namespace=") || line.contains("<xs:import xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" namespace=\"") || line.contains("<wsdl:import namespace=") || line.contains("<pd:ProcessDefinition "))) {
                        passedHeader = true;
                    }
                } else {
                    if (unusedNamespaces.isEmpty()) break;
                    keyList = new ArrayList<String>(unusedNamespaces.keySet());
                    for (String key : keyList) {
                        if (!line.matches(".*[^a-zA-Z0-9]+" + key + ":.*")) continue;
                        unusedNamespaces.remove(key);
                    }
                }
                line = br.readLine();
            }
            if (!unusedNamespaces.isEmpty()) {
                for (String prefix : unusedNamespaces.keySet()) {
                    if (this.checkIgnoreNamespace(unusedNamespaces.get(prefix))) continue;
                    errorList.add("WARNING! UnusedPrefix: " + prefix + " => " + unusedNamespaces.get(prefix));
                }
            }
            HashSet<String> namespaceList = new HashSet<String>(bwProcess.getNamespacePrefixes().values());
            namespaceList.removeAll(bwProcess.getImportedSchemaFiles().values());
            namespaceList.removeAll(unusedNamespaces.values());
            for (String string : namespaceList) {
                boolean foundCalledProcessNamespace = false;
                block11: for (String calledProcess : bwProcess.getCalledProcesses()) {
                    File calledProcessFile = new File(ProjectDirString + calledProcess);
                    if (!calledProcessFile.exists() || !calledProcessFile.isFile()) continue;
                    for (BwProcess calledBwProcess : this.project.getProcessList()) {
                        if (calledProcessFile.compareTo(calledBwProcess.getFile()) != 0 || !calledBwProcess.getNamespacePrefixes().containsValue(string)) continue;
                        foundCalledProcessNamespace = true;
                        continue block11;
                    }
                }
                if (this.checkIgnoreNamespace(string) || foundCalledProcessNamespace) continue;
                errorList.add("POSSIBLE ERROR! Namespace does not have associated file: " + string);
            }
            ArrayList<String> arrayList = errorList;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public void checkProject(String projectDirString) throws IOException {
        System.out.println("Processing project " + projectDirString);
        File projectDir = new File(projectDirString);
        if (projectDir.exists()) {
            List<String> fileList = GenericBWProcessChecker.getProcessFileList(projectDir);
            System.out.println("Number of processes found: " + fileList.size());
            boolean numFoundErrors_old = false;
            projectDirString = projectDir.getAbsolutePath();
            ArrayList<BwProcess> bwProcessList = new ArrayList<BwProcess>();
            for (String file : fileList) {
                bwProcessList.add(new BwProcess(file));
            }
            this.project.setProcessList(bwProcessList);
            if (!this.cfgFilePath.isEmpty()) {
                DesignTimeLibs designTimeLibs = new DesignTimeLibs(projectDirString, this.cfgFilePath);
                if (designTimeLibs.getDesigntimelibs() != null && !designTimeLibs.getDesigntimelibs().keySet().isEmpty()) {
                    System.out.println("");
                    System.out.println("Using configuration file " + this.cfgFilePath);
                    if (!designTimeLibs.getDesigntimelibs().keySet().isEmpty()) {
                        System.out.println("Found designtimelibs: ");
                        for (String key : designTimeLibs.getDesigntimelibs().keySet()) {
                            if (designTimeLibs.getDesigntimelibs().get(key).isEmpty()) {
                                System.out.println(key + ": Path not defined in cfg file");
                                continue;
                            }
                            System.out.println(key + ": " + designTimeLibs.getDesigntimelibs().get(key));
                        }
                        System.out.println("");
                    }
                }
                this.project.setDesignTimeLibs(designTimeLibs);
            }
            int numFoundErrors = 0;
            for (BwProcess bwProcess : this.project.getProcessList()) {
                ArrayList<String> errorList = this.checkProcessFile(bwProcess, projectDirString);
                if (errorList.isEmpty()) continue;
                numFoundErrors += errorList.size();
                System.out.println();
                System.out.println("**************************************");
                System.out.println("***** " + bwProcess.getFileLocation().substring(projectDirString.length()).replace('\\', '/'));
                for (String error : errorList) {
                    System.out.println(error);
                }
                System.out.println("**************************************");
            }
            System.out.println();
            System.out.println("Done. Found " + numFoundErrors + " Errors/Warnings.");
        } else {
            System.out.println();
            System.out.println("ERROR: Project not Found!");
        }
    }
}

