/*
 * Decompiled with CFR 0.152.
 */
package bmantunes.tibcheck;

import bmantunes.tibcheck.utils.DesignTimeLibs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GenericBWProcessChecker_old {
    private static final String[] defaultIgnoredNamespaces = new String[]{"http://www.w3.org/1999/XSL/Transform", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/wsdl/"};
    private static final String[] defaultIgnoredNamespacePrefixes = new String[]{"java://", "http://xmlns.tibco.com/", "http://www.w3.org/2001/XMLSchema", "http://www.tibco.com/", "http://schemas.tibco.com/", "www.tibco.com/"};
    DesignTimeLibs designTimeLibs;
    private boolean ignoreDefaultNamespaces = true;
    private final String cfgFilePath;

    private static List<String> getProcessFileList(File projectDir) throws FileNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        for (File currentFileOrDir : Arrays.asList(projectDir.listFiles())) {
            if (currentFileOrDir.isFile() && currentFileOrDir.getName().endsWith(".process")) {
                result.add(currentFileOrDir.getAbsolutePath());
            }
            if (!currentFileOrDir.isDirectory()) continue;
            List<String> childList = GenericBWProcessChecker_old.getProcessFileList(currentFileOrDir);
            result.addAll(childList);
        }
        return result;
    }

    public GenericBWProcessChecker_old(String cfgFilePath) {
        this.cfgFilePath = cfgFilePath;
    }

    private boolean checkIgnoreNamespace(String namespace) {
        if (this.ignoreDefaultNamespaces) {
            if (Arrays.asList(defaultIgnoredNamespaces).contains(namespace)) {
                return true;
            }
            for (String prefix : defaultIgnoredNamespacePrefixes) {
                if (!namespace.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> checkProcessFile(String processFilePath, String ProjectDirString) throws IOException {
        BufferedReader br = null;
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(processFilePath), "UTF-8");
            br = new BufferedReader(isr, 8192);
            ArrayList<String> errorList = new ArrayList<String>();
            HashMap<String, String> unusedNamespaces = new HashMap<String, String>();
            HashMap<String, String> allNamespaces = new HashMap<String, String>();
            HashMap<String, String> fileList = new HashMap<String, String>();
            String line = br.readLine();
            while (line != null) {
                String schemaLocation;
                String namespace;
                if (line.contains("<xsd:import namespace=") || line.contains("<xs:import xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" namespace=\"")) {
                    if (!line.contains("schemaLocation=\"")) {
                        namespace = line.substring(line.indexOf("namespace=\"") + 11, line.lastIndexOf("\""));
                        errorList.add("ERROR! Imported namespace does not have associated file location: " + namespace);
                    } else {
                        schemaLocation = line.substring(line.indexOf("schemaLocation=\"") + 16, line.lastIndexOf("\""));
                        if (schemaLocation.startsWith("/")) {
                            schemaLocation = schemaLocation.replaceFirst("/", "");
                        }
                        String namespace2 = line.substring(line.indexOf("namespace=\"") + 11, line.indexOf("schemaLocation=\"") - 2);
                        if (!new File(ProjectDirString + "/" + schemaLocation).exists()) {
                            boolean foundFile = false;
                            if (this.designTimeLibs != null && this.designTimeLibs.getDesigntimelibContents() != null) {
                                for (HashSet<String> projlibFiles : this.designTimeLibs.getDesigntimelibContents().values()) {
                                    if (!projlibFiles.contains(schemaLocation)) continue;
                                    foundFile = true;
                                    fileList.put(schemaLocation, namespace2);
                                }
                            }
                            if (!foundFile) {
                                errorList.add("ERROR! File Not Found: " + schemaLocation);
                            }
                        } else if (!allNamespaces.containsValue(namespace2) && !namespace2.contains("tibco.com/")) {
                            errorList.add("WARNING! File does not have associated prefix: " + schemaLocation);
                        } else {
                            fileList.put(schemaLocation, namespace2);
                        }
                    }
                } else if (line.contains("<wsdl:import namespace=")) {
                    if (!line.contains("location=\"")) {
                        namespace = line.substring(line.indexOf("namespace=\"") + 11, line.lastIndexOf("\""));
                        errorList.add("ERROR! Imported namespace does not have associated file location: " + namespace);
                    } else {
                        schemaLocation = line.substring(line.indexOf("location=\"") + 10, line.lastIndexOf("\""));
                        if (schemaLocation.startsWith("/")) {
                            schemaLocation = schemaLocation.replaceFirst("/", "");
                        }
                        String namespace3 = line.substring(line.indexOf("namespace=\"") + 11, line.indexOf("location=\"") - 2);
                        if (!new File(ProjectDirString + "/" + schemaLocation).exists()) {
                            errorList.add("ERROR! File Not Found: " + schemaLocation);
                        } else if (!allNamespaces.containsValue(namespace3) && !namespace3.contains("tibco.com/")) {
                            errorList.add("WARNING! File does not have associated prefix: " + schemaLocation);
                        } else {
                            fileList.put(schemaLocation, namespace3);
                        }
                    }
                } else if (line.contains("<pd:ProcessDefinition ")) {
                    String[] splitLine;
                    for (String token : splitLine = line.split("\" ")) {
                        String namespace4;
                        if (!token.startsWith("xmlns:") || this.checkIgnoreNamespace(namespace4 = token.lastIndexOf("\"") == token.indexOf("\"") ? token.substring(token.indexOf("\"") + 1) : token.substring(token.indexOf("\"") + 1, token.lastIndexOf("\"")))) continue;
                        allNamespaces.put(token.substring(6, token.indexOf("=")), namespace4);
                        unusedNamespaces.put(token.substring(6, token.indexOf("=")), namespace4);
                    }
                } else if (!unusedNamespaces.isEmpty()) {
                    String[] prefixList = new String[]{""};
                    prefixList = unusedNamespaces.keySet().toArray(prefixList);
                    for (int i = 0; i < prefixList.length; ++i) {
                        if (!line.contains(prefixList[i] + ":")) continue;
                        unusedNamespaces.remove(prefixList[i]);
                    }
                }
                line = br.readLine();
            }
            if (!unusedNamespaces.isEmpty()) {
                for (Map.Entry prefix : unusedNamespaces.entrySet()) {
                    errorList.add("WARNING! UnusedPrefix: " + (String)prefix.getKey() + " => " + (String)prefix.getValue());
                }
            }
            for (String namespace : allNamespaces.values()) {
                if (fileList.containsValue(namespace) || unusedNamespaces.containsValue(namespace)) continue;
                errorList.add("POSSIBLE ERROR! Namespace does not have associated file: " + namespace);
            }
            ArrayList<String> arrayList = errorList;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public void checkProject(String projectDirString) throws IOException {
        File projectDir;
        System.out.println("Processing project " + projectDirString);
        if (!this.cfgFilePath.isEmpty()) {
            this.designTimeLibs = new DesignTimeLibs(projectDirString, this.cfgFilePath);
            if (this.designTimeLibs.getDesigntimelibs() != null && !this.designTimeLibs.getDesigntimelibs().keySet().isEmpty()) {
                System.out.println("");
                System.out.println("Using configuration file " + this.cfgFilePath);
                if (!this.designTimeLibs.getDesigntimelibs().keySet().isEmpty()) {
                    System.out.println("Found designtimelibs: ");
                    for (String key : this.designTimeLibs.getDesigntimelibs().keySet()) {
                        if (this.designTimeLibs.getDesigntimelibs().get(key).isEmpty()) {
                            System.out.println(key + ": Path not defined in cfg file");
                            continue;
                        }
                        System.out.println(key + ": " + this.designTimeLibs.getDesigntimelibs().get(key));
                    }
                    System.out.println("");
                }
            }
        }
        if ((projectDir = new File(projectDirString)).exists()) {
            List<String> fileList = GenericBWProcessChecker_old.getProcessFileList(projectDir);
            System.out.println("Number of processes found: " + fileList.size());
            int numFoundErrors = 0;
            projectDirString = projectDir.getAbsolutePath();
            for (String file : fileList) {
                ArrayList<String> errorList = this.checkProcessFile(file, projectDirString);
                if (errorList.isEmpty()) continue;
                numFoundErrors += errorList.size();
                System.out.println();
                System.out.println("**************************************");
                System.out.println("***** " + file.substring(projectDirString.length()).replace('\\', '/'));
                for (String error : errorList) {
                    System.out.println(error);
                }
                System.out.println("**************************************");
            }
            System.out.println();
            System.out.println("Done. Found " + numFoundErrors + " Errors/Warnings.");
        } else {
            System.out.println();
            System.out.println("ERROR: Project not Found!");
        }
    }
}

