/*
 * Decompiled with CFR 0.152.
 */
package bmantunes.tibcheck.bw;

import bmantunes.tibcheck.bw.AbstractBwFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BwProcess
extends AbstractBwFile {
    private HashMap<String, String> namespacePrefixes = new HashMap();
    private HashMap<String, String> importedSchemaFiles = new HashMap();
    private HashSet<String> calledProcesses = new HashSet();
    private HashSet<String> starterNamespaces = new HashSet();
    private HashSet<String> endNamespaces = new HashSet();
    private ArrayList<String> errorImportWithoutLocation = new ArrayList();
    private XPath xPath = XPathFactory.newInstance().newXPath();

    public BwProcess(String fileLocation) {
        super(fileLocation);
        try {
            this.initMetadata();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(BwProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(BwProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(BwProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(BwProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public AbstractBwFile.FileType getFileType() {
        return AbstractBwFile.FileType.BwProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetadata() throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        FileInputStream fis = null;
        try {
            DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            fis = new FileInputStream(this.getFileLocation());
            Element documentElement = b.parse(fis).getDocumentElement();
            this.setNamespacePrefixes(documentElement);
            this.setCalledProcesses(documentElement);
            this.setEndNamespaces(documentElement);
            this.setImportedSchemaFiles(documentElement);
            this.setStarterNamespaces(documentElement);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void setNamespacePrefixes(Element documentElement) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.xPath.evaluate("/ProcessDefinition", documentElement, XPathConstants.NODESET);
        NamedNodeMap attributeNodeMap = ((Element)nodes.item(0)).getAttributes();
        for (int i = 0; i < attributeNodeMap.getLength(); ++i) {
            Attr attribute = (Attr)attributeNodeMap.item(i);
            this.namespacePrefixes.put(attribute.getName().replace("xmlns:", ""), attribute.getValue());
        }
    }

    private void setImportedSchemaFiles(Element documentElement) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.xPath.evaluate("/ProcessDefinition/import", documentElement, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            if (!e.getAttribute("schemaLocation").isEmpty()) {
                this.importedSchemaFiles.put(e.getAttribute("schemaLocation"), e.getAttribute("namespace"));
                continue;
            }
            if (!e.getAttribute("location").isEmpty()) {
                this.importedSchemaFiles.put(e.getAttribute("location"), e.getAttribute("namespace"));
                continue;
            }
            this.errorImportWithoutLocation.add(e.getAttribute("namespace"));
        }
    }

    private void setCalledProcesses(Element documentElement) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.xPath.evaluate("/ProcessDefinition/activity[type='com.tibco.pe.core.CallProcessActivity']/config/processName", documentElement, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            this.calledProcesses.add(e.getTextContent());
        }
    }

    private void setStarterNamespaces(Element documentElement) {
    }

    private void setEndNamespaces(Element documentElement) {
    }

    public HashMap<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public HashMap<String, String> getImportedSchemaFiles() {
        return this.importedSchemaFiles;
    }

    public HashSet<String> getCalledProcesses() {
        return this.calledProcesses;
    }

    public HashSet<String> getStarterNamespaces() {
        return this.starterNamespaces;
    }

    public HashSet<String> getEndNamespaces() {
        return this.endNamespaces;
    }

    public ArrayList<String> getErrorImportWithoutLocation() {
        return this.errorImportWithoutLocation;
    }
}

