/*
 * Decompiled with CFR 0.152.
 */
package bmantunes.tibcheck.utils;

import bmantunes.utils.UnZip;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DesignTimeLibs {
    private HashMap<String, String> designtimelibs;
    private HashMap<String, HashSet<String>> designtimelibContents;

    private DesignTimeLibs() {
    }

    public HashMap<String, String> getDesigntimelibs() {
        return this.designtimelibs;
    }

    public HashMap<String, HashSet<String>> getDesigntimelibContents() {
        return this.designtimelibContents;
    }

    private void setDesigntimelibContents() throws IOException {
        Set<Map.Entry<String, String>> es = this.designtimelibs.entrySet();
        if (!es.isEmpty()) {
            this.designtimelibContents = new HashMap(es.size());
            for (Map.Entry<String, String> entry : es) {
                HashSet<String> projlibFiles = new HashSet<String>(UnZip.getZipFileList(entry.getValue()));
                this.designtimelibContents.put(entry.getKey(), projlibFiles);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesignTimeLibs(String projectPath, String cfgFilePath) throws IOException {
        if (this.existsCfgFile(cfgFilePath)) {
            this.designtimelibs = new HashMap();
            BufferedReader br = null;
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(projectPath + "/.designtimelibs"), "UTF-8");
                br = new BufferedReader(isr, 8192);
                String line = br.readLine();
                while (line != null) {
                    String cleanLine;
                    if (!line.trim().startsWith("#") && (cleanLine = line.substring(line.indexOf(61) + 1, line.indexOf("\\="))).endsWith(".projlib")) {
                        this.designtimelibs.put(cleanLine, this.getAliasPathFromCfg(cleanLine, cfgFilePath));
                    }
                    line = br.readLine();
                }
                this.setDesigntimelibContents();
            }
            catch (FileNotFoundException ex) {
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAliasPathFromCfg(String alias, String cfgFilePath) throws IOException {
        BufferedReader br = null;
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(cfgFilePath), "UTF-8");
            br = new BufferedReader(isr, 8192);
            String line = br.readLine();
            while (line != null) {
                String[] splitLine;
                if (!line.trim().startsWith("#") && (splitLine = line.split("=")).length == 2 && splitLine[0].equals(alias)) {
                    String string = splitLine[1];
                    return string;
                }
                line = br.readLine();
            }
            String string = "";
            return string;
        }
        catch (FileNotFoundException ex) {
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private boolean existsCfgFile(String cfgFilePath) throws IOException {
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(cfgFilePath), "UTF-8");
            isr.close();
            return true;
        }
        catch (FileNotFoundException ex) {
            System.out.println("Configuration file not found: " + cfgFilePath);
            return false;
        }
    }
}

