#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0600

#include <windows.h>

#define EXPORT __declspec(dllexport)

USHORT g_scanCodeUp = 0, g_scanCodeDown = 0, g_scanCodeLeft = 0, g_scanCodeRight = 0;

BOOL APIENTRY DllMain(HMODULE hModule, DWORD dwReason, LPVOID lpStaticLoad)
{
	if(dwReason == DLL_PROCESS_ATTACH)
	{
		g_scanCodeUp = (USHORT)MapVirtualKey(VK_UP, MAPVK_VK_TO_VSC);
		g_scanCodeDown = (USHORT)MapVirtualKey(VK_DOWN, MAPVK_VK_TO_VSC);
		g_scanCodeLeft = (USHORT)MapVirtualKey(VK_LEFT, MAPVK_VK_TO_VSC);
		g_scanCodeRight = (USHORT)MapVirtualKey(VK_RIGHT, MAPVK_VK_TO_VSC);
	}
	return TRUE;
	/* bits we don't use */
	UNREFERENCED_PARAMETER(hModule);
	UNREFERENCED_PARAMETER(lpStaticLoad);
}

/* 
*  Firefox has logic that stops mouse wheel scrolling if the mouse isn't over one of its windows
*  http://mxr.mozilla.org/mozilla/source/widget/src/windows/nsWindow.cpp#5186 (at time of writing)
*  so we translate the scroll wheel into sending up and down cursor key presses to the top level window
*/

EXPORT
STDAPI_(BOOL)
OnWheel(
	HWND hwndTopLevel,
	HWND hwndScrolledChild,
	int xScrollPos, /* Within the hwndScrolledChild client area */
	int yScrollPos, /* ditto */
	int scrollZDelta,
	UINT keyFlags
)
{
	DWORD keyToSend;
	DWORD scanCode;
	int i;
	LPARAM keylParam;
	if(scrollZDelta > 0) /* positive deltas are scrolling up */
	{
		keyToSend = VK_UP;
		scanCode = g_scanCodeUp;
	}
	else
	{
		scrollZDelta = -scrollZDelta;
		keyToSend = VK_DOWN;
		scanCode = g_scanCodeDown;
	}
	/* round up to next full key repeat */
	scrollZDelta = ((scrollZDelta / WHEEL_DELTA) + 1);
	keylParam = MAKELPARAM(1, scanCode);
	for(i = 0; i < scrollZDelta; ++i)
	{
		PostMessage(hwndScrolledChild, WM_KEYDOWN, keyToSend, keylParam);
		/* If we're sending more than one, set the 'previous key state' flag */
		keylParam |= (KF_REPEAT << 16);
	}
	/* the two high bits are always set in flags for WM_KEYUP */
	keylParam = MAKELPARAM(1, scanCode | 0xC000);
	PostMessage(hwndScrolledChild, WM_KEYUP, keyToSend, keylParam);
	return TRUE;
	/* bits we don't use */
	UNREFERENCED_PARAMETER(hwndTopLevel);
	UNREFERENCED_PARAMETER(xScrollPos);
	UNREFERENCED_PARAMETER(yScrollPos);
	UNREFERENCED_PARAMETER(keyFlags);
}

EXPORT
STDAPI_(BOOL)
OnHWheel(
	HWND hwndTopLevel,
	HWND hwndScrolledChild,
	int xScrollPos, /* Within the hwndScrolledChild client area */
	int yScrollPos, /* ditto */
	int scrollYDelta,
	UINT keyFlags
)
{
	DWORD keyToSend;
	DWORD scanCode;
	int i;
	LPARAM keylParam;
	if(scrollYDelta > 0) /* posiive deltas are scrolling right */
	{
		keyToSend = VK_RIGHT;
		scanCode = g_scanCodeRight;
	}
	else
	{
		scrollYDelta = -scrollYDelta;
		keyToSend = VK_LEFT;
		scanCode = g_scanCodeLeft;
	}
	/* round up to next full key repeat */
	scrollYDelta = ((scrollYDelta / WHEEL_DELTA) + 1);
	keylParam = MAKELPARAM(1, scanCode);
	for(i = 0; i < scrollYDelta; ++i)
	{
		PostMessage(hwndScrolledChild, WM_KEYDOWN, keyToSend, keylParam);
		/* If we're sending more than one, set the 'previous key state' flag */
		keylParam |= (KF_REPEAT << 16);
	}
	/* the two high bits are always set in flags for WM_KEYUP */
	keylParam = MAKELPARAM(1, scanCode | 0xC000);
	PostMessage(hwndScrolledChild, WM_KEYUP, keyToSend, keylParam);
	return TRUE;
	/* bits we don't use */
	UNREFERENCED_PARAMETER(hwndTopLevel);
	UNREFERENCED_PARAMETER(xScrollPos);
	UNREFERENCED_PARAMETER(yScrollPos);
	UNREFERENCED_PARAMETER(keyFlags);
}

