#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0600

#include <windows.h>

#define EXPORT __declspec(dllexport)
#pragma intrinsic(wcscmp)

HWND g_TabHwnd = NULL;
USHORT g_scanCodeSpace = 0;
/* The window class of Internet Explorer's tabs */
static const LPCWSTR g_tabWndClass = L"DirectUIHWND";

BOOL APIENTRY DllMain(HMODULE hModule, DWORD dwReason, LPVOID lpStaticLoad)
{
	BOOL dllLoad = TRUE;
	if(dwReason == DLL_PROCESS_ATTACH)
	{
		/* Find the scancode of the space key so we can send to IE and select the tabs */
		g_scanCodeSpace = (USHORT)MapVirtualKey(VK_SPACE, MAPVK_VK_TO_VSC);
		dllLoad = (g_scanCodeSpace != 0);
	}
	return dllLoad;
	/* bits we don't use */
	UNREFERENCED_PARAMETER(hModule);
	UNREFERENCED_PARAMETER(lpStaticLoad);
}

BOOL IsTabHWND(HWND hwnd)
{
	BOOL ret = (hwnd == g_TabHwnd);
	if(!ret)
	{
		if(!g_TabHwnd)
		{
			/* these are the characteristics of the tab class */
			WCHAR name[13] = {0};
			GetClassName(hwnd, name, ARRAYSIZE(name));
			if( (wcscmp(name, g_tabWndClass) == 0) && 
				(GetClassLongPtr(hwnd, GCL_STYLE) & CS_GLOBALCLASS) &&
				(GetWindowLongPtr(hwnd, GWL_STYLE) & WS_CHILDWINDOW)
			)
			{
				g_TabHwnd = hwnd;
				ret = TRUE;
			}
		}
	}
	return ret;
}

/* 
*  Internet Explorer's tabs don't respond directly to clicks, which only makes them take focus
*  rather than switch to the new tab. So we send the click as WindowWatcher normally would
*  and then send a press of the space bar to actually select the new selection
*/

EXPORT
STDAPI_(BOOL)
OnLClick(
	HWND hwndClickedChild,
	int xClickPos, /* Within the hwndScrolledChild client area */
	int yClickPos, /* ditto */
	UINT keyFlags
)
{
	BOOL ret = FALSE;
	if(IsTabHWND(hwndClickedChild))
	{
		LPARAM clickLocation = MAKELPARAM(xClickPos, yClickPos);
		LPARAM keyParam = MAKELPARAM(1, g_scanCodeSpace);
		/* These 2 messages make the tab take focus but not activate */
		PostMessage(hwndClickedChild, WM_LBUTTONDOWN, keyFlags | MK_LBUTTON, clickLocation);
		PostMessage(hwndClickedChild, WM_LBUTTONUP, keyFlags, clickLocation);
		/* Sending the space while focused causes the switch */
		PostMessage(hwndClickedChild, WM_KEYDOWN, VK_SPACE, keyParam);
		/* The two high bits are set for WM_KEYUP */
		keyParam |= (0xC000 << 16);
		PostMessage(hwndClickedChild, WM_KEYUP, VK_SPACE, keyParam);
	}
	return ret;
}