/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DefCountryGroupsDialog
extends Dialog
implements ListSelectionListener {
    private JButton btnAdd;
    private JButton btnCancel;
    private JButton btnEdit;
    private JButton btnRemove;
    private JTable jGroups;
    private JScrollPane jScrollPane1;

    public DefCountryGroupsDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setTitle("Define country groups");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension sz = kit.getScreenSize();
        int sH = (int)sz.getHeight();
        int sW = (int)sz.getWidth();
        this.setLocation(sW / 2 - (int)this.getSize().getWidth() / 2, sH / 2 - (int)this.getSize().getHeight() / 2);
        this.jGroups.setModel(new DefaultTableModel((Object[][])null, new String[]{"Code", "Name"}));
        this.jGroups.getSelectionModel().setSelectionMode(0);
        this.jGroups.getSelectionModel().addListSelectionListener(this);
        this.btnAdd.setMnemonic(65);
        this.btnEdit.setMnemonic(69);
        this.btnRemove.setMnemonic(82);
        this.fillTable();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() != this.jGroups.getSelectionModel()) {
            return;
        }
        int idx = -1;
        if (!e.getValueIsAdjusting()) {
            idx = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
        }
        this.btnEdit.setEnabled(idx >= 0);
        this.btnRemove.setEnabled(idx >= 0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jGroups = new JTable();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnCancel = new JButton();
        this.setLayout(new AbsoluteLayout());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DefCountryGroupsDialog.this.closeDialog(evt);
            }
        });
        this.jGroups.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jGroups.setPreferredSize(new Dimension(50, 64));
        this.jScrollPane1.setViewportView(this.jGroups);
        this.add((Component)this.jScrollPane1, new AbsoluteConstraints(20, 30, 310, 160));
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/add.gif")));
        this.btnAdd.setLabel("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DefCountryGroupsDialog.this.btnAddActionPerformed(evt);
            }
        });
        this.add((Component)this.btnAdd, new AbsoluteConstraints(340, 30, 110, -1));
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/edit.gif")));
        this.btnEdit.setLabel("Edit");
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DefCountryGroupsDialog.this.btnEditActionPerformed(evt);
            }
        });
        this.add((Component)this.btnEdit, new AbsoluteConstraints(340, 60, 110, -1));
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/remove.gif")));
        this.btnRemove.setLabel("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DefCountryGroupsDialog.this.btnRemoveActionPerformed(evt);
            }
        });
        this.add((Component)this.btnRemove, new AbsoluteConstraints(340, 90, 110, -1));
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/exit.gif")));
        this.btnCancel.setLabel("Exit");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DefCountryGroupsDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.add((Component)this.btnCancel, new AbsoluteConstraints(190, 210, 80, 30));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 464) / 2, (screenSize.height - 276) / 2, 464, 276);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.hide();
        this.dispose();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        Group newGroup = new Group();
        EditCountryGroupDialog eg = new EditCountryGroupDialog((Frame)this.getParent(), newGroup);
        eg.setVisible(true);
        if (eg.isOk()) {
            WoSAppData.theAppData.getWosGroups().add(newGroup);
            this.fillTable();
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int idx = this.jGroups.getSelectedRow();
        WoSAppData.theAppData.getWosGroups().remove(idx);
        this.fillTable();
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        int idx = this.jGroups.getSelectedRow();
        Group grp = WoSAppData.theAppData.getWosGroups().get(idx);
        Group editGrp = new Group(grp);
        EditCountryGroupDialog eg = new EditCountryGroupDialog((Frame)this.getParent(), editGrp);
        eg.setVisible(true);
        if (eg.isOk()) {
            WoSAppData.theAppData.getWosGroups().set(idx, editGrp);
            this.fillTable();
            this.jGroups.getSelectionModel().setSelectionInterval(idx, idx);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void fillTable() {
        ((DefaultTableModel)this.jGroups.getModel()).setRowCount(0);
        for (Group grp : WoSAppData.theAppData.getWosGroups()) {
            ((DefaultTableModel)this.jGroups.getModel()).addRow(new Object[]{grp.getCode(), grp.getName()});
        }
    }
}

