/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class EditCountryGroupDialog
extends Dialog {
    private JButton btnAdd;
    private JButton btnCancel;
    private JButton btnOk;
    private JButton btnRemove;
    private JTextField jCode;
    private JTextField jName;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private Label label1;
    private Label label2;
    private Label label3;
    private Label label4;
    private List lstAllCountries;
    private List lstGrpCountries;
    private Group group;
    private boolean ok = false;
    private ArrayList<Country> allCountries;

    public EditCountryGroupDialog(Frame parent, Group pGroup) {
        super(parent, true);
        this.initComponents();
        this.group = pGroup;
        this.initAllCountries();
        this.putCodeName();
        this.fillLists();
    }

    private void initComponents() {
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.label1 = new Label();
        this.label2 = new Label();
        this.jCode = new JTextField();
        this.jName = new JTextField();
        this.jPanel2 = new JPanel();
        this.label3 = new Label();
        this.label4 = new Label();
        this.lstAllCountries = new List();
        this.lstGrpCountries = new List();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.setLayout(new AbsoluteLayout());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditCountryGroupDialog.this.closeDialog(evt);
            }
        });
        this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/accept.gif")));
        this.btnOk.setLabel("Ok");
        this.btnOk.setMaximumSize(new Dimension(95, 26));
        this.btnOk.setMinimumSize(new Dimension(95, 26));
        this.btnOk.setPreferredSize(new Dimension(95, 26));
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCountryGroupDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.add((Component)this.btnOk, new AbsoluteConstraints(130, 260, -1, 30));
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/reject.gif")));
        this.btnCancel.setLabel("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCountryGroupDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.add((Component)this.btnCancel, new AbsoluteConstraints(230, 260, -1, 30));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(new TitledBorder(new TitledBorder("Group code and name")));
        this.label1.setText("Code");
        this.jPanel1.add((Component)this.label1, new AbsoluteConstraints(10, 20, -1, 20));
        this.label2.setText("Name");
        this.jPanel1.add((Component)this.label2, new AbsoluteConstraints(10, 40, -1, -1));
        this.jPanel1.add((Component)this.jCode, new AbsoluteConstraints(80, 20, 310, -1));
        this.jPanel1.add((Component)this.jName, new AbsoluteConstraints(80, 40, 310, -1));
        this.add((Component)this.jPanel1, new AbsoluteConstraints(20, 30, 400, 70));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jPanel2.setBorder(new TitledBorder("Group countries"));
        this.label3.setText("Available countries");
        this.jPanel2.add((Component)this.label3, new AbsoluteConstraints(10, 20, -1, -1));
        this.label4.setText("Countries in group");
        this.jPanel2.add((Component)this.label4, new AbsoluteConstraints(280, 20, -1, -1));
        this.lstAllCountries.setMultipleMode(true);
        this.lstAllCountries.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EditCountryGroupDialog.this.lstAllCountriesItemStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.lstAllCountries, new AbsoluteConstraints(10, 50, 160, -1));
        this.lstGrpCountries.setMultipleMode(true);
        this.lstGrpCountries.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EditCountryGroupDialog.this.lstGrpCountriesItemStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.lstGrpCountries, new AbsoluteConstraints(240, 50, 150, -1));
        this.btnAdd.setLabel("->");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCountryGroupDialog.this.btnAddActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.btnAdd, new AbsoluteConstraints(180, 60, -1, -1));
        this.btnRemove.setLabel("<-");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCountryGroupDialog.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.btnRemove, new AbsoluteConstraints(180, 100, -1, -1));
        this.add((Component)this.jPanel2, new AbsoluteConstraints(20, 109, 400, 140));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 451) / 2, (screenSize.height - 329) / 2, 451, 329);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int[] selIdx = this.lstGrpCountries.getSelectedIndexes();
        ArrayList<Country> selCountires = new ArrayList<Country>();
        for (int i : selIdx) {
            selCountires.add(this.group.getCountries().get(i));
        }
        for (Country ctry : selCountires) {
            this.allCountries.add(ctry);
            this.group.getCountries().remove(ctry);
        }
        this.fillLists();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        int[] selIdx = this.lstAllCountries.getSelectedIndexes();
        ArrayList<Country> selCountires = new ArrayList<Country>();
        for (int i : selIdx) {
            selCountires.add(this.allCountries.get(i));
        }
        for (Country ctry : selCountires) {
            this.group.getCountries().add(ctry);
            this.allCountries.remove(ctry);
        }
        this.fillLists();
    }

    private void lstGrpCountriesItemStateChanged(ItemEvent evt) {
        int[] selIdx = this.lstGrpCountries.getSelectedIndexes();
        this.btnRemove.setEnabled(selIdx.length >= 1);
    }

    private void lstAllCountriesItemStateChanged(ItemEvent evt) {
        int[] selIdx = this.lstAllCountries.getSelectedIndexes();
        this.btnAdd.setEnabled(selIdx.length >= 1);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.hide();
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (!this.readCodeName()) {
            return;
        }
        this.ok = true;
        this.hide();
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    private boolean readCodeName() {
        String txtCode = this.jCode.getText();
        String txtName = this.jName.getText();
        if (txtCode == null || txtCode.length() < 3) {
            JOptionPane.showMessageDialog(null, "Group code must be at least 3 characters long!", "WoS Error", 0);
            this.jCode.requestFocus();
            return false;
        }
        if (txtName == null || txtName.length() < 3) {
            JOptionPane.showMessageDialog(null, "Group name is invalid!", "WoS Error", 0);
            this.jName.requestFocus();
            return false;
        }
        this.group.setCode(txtCode);
        this.group.setName(txtName);
        return true;
    }

    private void putCodeName() {
        this.jCode.setText(this.group.getCode());
        this.jName.setText(this.group.getName());
        this.jPanel1.setEnabled(this.jCode.getText() != null && this.jCode.getText().length() > 0 && this.jName.getText() != null && this.jName.getText().length() > 0);
    }

    private void initAllCountries() {
        this.allCountries = new ArrayList();
        for (Country ctry : WoSAppData.theAppData.getWosCountries()) {
            if (this.group.getCountries().contains(ctry)) continue;
            this.allCountries.add(ctry);
        }
    }

    private void fillLists() {
        this.lstAllCountries.removeAll();
        for (Country ctry : this.allCountries) {
            this.lstAllCountries.add(ctry.toString());
        }
        this.lstGrpCountries.removeAll();
        for (Country ctry : this.group.getCountries()) {
            this.lstGrpCountries.add(ctry.toString());
        }
    }
}

