/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class EditValueDialog
extends Dialog {
    private boolean editMode = false;
    private boolean ok;
    private WoSDocValue wosValue;
    private WoSDocData wosData;
    private JButton btnCancel;
    private JButton btnOk;
    private Choice cmbCountry;
    private Choice cmbGroup;
    private Label label1;
    private Label label2;
    private Checkbox rdCountry;
    private Checkbox rdGroup;
    private JTextField txtValue;

    public EditValueDialog(Frame parent, WoSDocValue wosVal, WoSDocData wosDt) {
        super(parent, true);
        this.wosValue = wosVal;
        this.wosData = wosDt;
        this.initComponents();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension sz = kit.getScreenSize();
        int sH = (int)sz.getHeight();
        int sW = (int)sz.getWidth();
        this.setLocation(sW / 2 - (int)this.getSize().getWidth() / 2, sH / 2 - (int)this.getSize().getHeight() / 2);
        this.fillCombos();
        this.putValues();
        if (this.wosValue.getEntity() != null) {
            this.editMode = true;
            this.cmbCountry.setEnabled(false);
            this.rdCountry.setEnabled(false);
            this.cmbGroup.setEnabled(false);
            this.rdGroup.setEnabled(false);
        }
        this.enableCombos();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initComponents() {
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.label1 = new Label();
        this.cmbCountry = new Choice();
        this.cmbGroup = new Choice();
        this.label2 = new Label();
        this.txtValue = new JTextField();
        this.rdCountry = new Checkbox();
        this.rdGroup = new Checkbox();
        this.setLayout(new AbsoluteLayout());
        this.setResizable(false);
        this.setTitle("Add/edit value");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditValueDialog.this.closeDialog(evt);
            }
        });
        this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/accept.gif")));
        this.btnOk.setLabel("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditValueDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.add((Component)this.btnOk, new AbsoluteConstraints(40, 170, 100, 30));
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/reject.gif")));
        this.btnCancel.setLabel("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditValueDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.add((Component)this.btnCancel, new AbsoluteConstraints(150, 170, 100, 30));
        this.label1.setText("Define value for:");
        this.add((Component)this.label1, new AbsoluteConstraints(20, 30, -1, -1));
        this.add((Component)this.cmbCountry, new AbsoluteConstraints(110, 60, 160, -1));
        this.add((Component)this.cmbGroup, new AbsoluteConstraints(110, 90, 160, -1));
        this.label2.setText("Value");
        this.add((Component)this.label2, new AbsoluteConstraints(20, 140, -1, -1));
        this.txtValue.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                EditValueDialog.this.txtValueKeyTyped(evt);
            }
        });
        this.add((Component)this.txtValue, new AbsoluteConstraints(70, 140, 180, -1));
        this.rdCountry.setLabel("Country");
        this.rdCountry.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EditValueDialog.this.rdCountryItemStateChanged(evt);
            }
        });
        this.rdCountry.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EditValueDialog.this.rdCountryMouseClicked(evt);
            }
        });
        this.add((Component)this.rdCountry, new AbsoluteConstraints(30, 60, -1, -1));
        this.rdGroup.setLabel("Group");
        this.rdGroup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EditValueDialog.this.rdGroupItemStateChanged(evt);
            }
        });
        this.rdGroup.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EditValueDialog.this.rdGroupMouseClicked(evt);
            }
        });
        this.add((Component)this.rdGroup, new AbsoluteConstraints(30, 90, -1, -1));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 296) / 2, (screenSize.height - 234) / 2, 296, 234);
    }

    private void rdGroupItemStateChanged(ItemEvent evt) {
        this.rdCountry.setState(!this.rdGroup.getState());
        this.enableCombos();
    }

    private void rdCountryItemStateChanged(ItemEvent evt) {
        this.rdGroup.setState(!this.rdCountry.getState());
        this.enableCombos();
    }

    private void rdGroupMouseClicked(MouseEvent evt) {
    }

    private void rdCountryMouseClicked(MouseEvent evt) {
    }

    private void txtValueKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c != '\b' && c != '\u007f' && c != '\n' && c != '\t' && c != '-' && c != '.' && !Character.isDigit(c)) {
            evt.consume();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.hide();
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        try {
            if (!this.readValues()) {
                return;
            }
            boolean alreadyExist = false;
            for (WoSDocValue wosVal : this.wosData.getWosValueSet()) {
                if (wosVal.getEntity().getCode() != this.wosValue.getEntity().getCode() && (!(wosVal.getEntity() instanceof Group) || !(this.wosValue.getEntity() instanceof Country) || !((Group)wosVal.getEntity()).getCountries().contains(this.wosValue.getEntity()))) continue;
                alreadyExist = true;
                break;
            }
            if (alreadyExist && !this.editMode) {
                JOptionPane.showMessageDialog(null, "Country or group " + this.wosValue.getEntity().toString() + " has already been added to this document. Cannot proceed!", "WoS Error", 0);
                return;
            }
            this.ok = true;
            this.hide();
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot store values!", "WoS Error", 0);
            System.out.print(ex.toString() + "\n");
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void enableCombos() {
        this.cmbCountry.setVisible(this.rdCountry.getState());
        this.cmbGroup.setVisible(this.rdGroup.getState());
    }

    private void fillCombos() {
        for (int i = 0; i < WoSAppData.theAppData.getWosCountries().size(); ++i) {
            this.cmbCountry.add(WoSAppData.theAppData.getWosCountries().get(i).toString());
        }
        for (int j = 0; j < WoSAppData.theAppData.getWosGroups().size(); ++j) {
            this.cmbGroup.add(WoSAppData.theAppData.getWosGroups().get(j).toString());
        }
    }

    private void putValues() {
        this.txtValue.setText(WoSDocValue.convertValueToString(this.wosValue.getValue()));
        boolean bGroup = this.wosValue.getEntity() instanceof Group;
        this.rdCountry.setState(!bGroup);
        this.rdGroup.setState(bGroup);
        this.rdCountryMouseClicked(null);
        this.rdGroupMouseClicked(null);
        this.cmbGroup.select("");
        this.cmbCountry.select("");
        if (this.wosValue.getEntity() != null) {
            if (bGroup) {
                this.cmbGroup.select(this.wosValue.getEntity().toString());
            } else {
                this.cmbCountry.select(this.wosValue.getEntity().toString());
            }
        }
    }

    private boolean readValues() {
        if (this.txtValue.getText().length() == 0) {
            this.txtValue.requestFocus();
            return false;
        }
        this.wosValue.setValue(Double.valueOf(this.txtValue.getText()));
        if (this.rdCountry.getState()) {
            if (this.cmbCountry.getSelectedIndex() < 0) {
                this.cmbCountry.requestFocus();
                return false;
            }
            this.wosValue.setEntity(WoSAppData.theAppData.getWosCountries().get(this.cmbCountry.getSelectedIndex()));
        } else {
            if (this.cmbGroup.getSelectedIndex() < 0) {
                this.cmbGroup.requestFocus();
                return false;
            }
            this.wosValue.setEntity(WoSAppData.theAppData.getWosGroups().get(this.cmbGroup.getSelectedIndex()));
        }
        return true;
    }
}

