/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;

public class MapDialog
extends Dialog {
    public static boolean demoVersion = true;
    private static int demoCtryNo = 15;
    private int lastZoom = 0;
    protected JSVGCanvas svgCanvas = new JSVGCanvas();
    protected JSVGScrollPane jsvgScrollPane = new JSVGScrollPane(this.svgCanvas);
    private JButton btnClose;
    private JButton btnExport;
    private JButton btnMaximize;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private Label label;
    private JButton zoomIn;
    private JButton zoomOut;
    private WoSDocData wosDocData;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private Vector<WoSDocValue> distinctVal;
    private int colorNo = 0;
    private static int MAXCOLORNO_RANGEMODE = 6;
    private static int MAXCOLORNO_SINGLEMODE = 4;
    private boolean rangeMode = false;
    private int noRetries = 0;

    public MapDialog(Frame parent, WoSDocData docData) {
        super(parent, true);
        this.initComponents();
        if (demoVersion) {
            JOptionPane.showMessageDialog(null, "You are running a demo version of WoS. The statistical map cannot display more than " + Integer.toString(demoCtryNo) + " countries or groups!", "WoS Warning", 2);
        }
        this.wosDocData = docData;
        this.minValue = this.wosDocData.getMinValue();
        this.maxValue = this.wosDocData.getMaxValue();
        this.distinctVal = this.wosDocData.getDistinctValues();
        this.colorNo = this.distinctVal.size();
        if (this.colorNo > MAXCOLORNO_SINGLEMODE) {
            --this.colorNo;
            if (this.colorNo > MAXCOLORNO_RANGEMODE) {
                this.colorNo = MAXCOLORNO_RANGEMODE;
            }
            this.rangeMode = true;
        }
        this.setTitle("Statistical map of: " + (docData.getFile() != null ? docData.getFile().getName() : "<<New wos document>>"));
        this.setSize((int)((double)MainForm.theMainForm.getWidth() * 0.75), (int)((double)MainForm.theMainForm.getHeight() * 0.75));
        this.svgCanvas.setRecenterOnResize(true);
        this.jPanel1.add("Center", this.jsvgScrollPane);
        this.zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MapDialog.this.lastZoom = -1;
                JSVGCanvas jSVGCanvas = MapDialog.this.svgCanvas;
                jSVGCanvas.getClass();
                JSVGCanvas.ZoomAction zAction = jSVGCanvas.new JSVGCanvas.ZoomAction(1.2);
                zAction.actionPerformed(null);
            }
        });
        this.zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MapDialog.this.lastZoom = 1;
                JSVGCanvas jSVGCanvas = MapDialog.this.svgCanvas;
                jSVGCanvas.getClass();
                JSVGCanvas.ZoomAction zAction = jSVGCanvas.new JSVGCanvas.ZoomAction(0.8);
                zAction.actionPerformed(null);
            }
        });
        this.svgCanvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                MapDialog.this.label.setText("Please wait...");
                MapDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                MapDialog.this.label.setText("Document Loaded.");
            }
        });
        this.svgCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                MapDialog.this.label.setText("Please wait...");
                MapDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                MapDialog.this.label.setText("Build Done.");
                MapDialog.this.pack();
            }
        });
        this.svgCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                MapDialog.this.label.setText("Please wait...");
                MapDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                MapDialog.this.label.setText("");
                MapDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                MapDialog.this.fillMap();
                MapDialog.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        try {
            this.svgCanvas.setURI(this.getClass().getResource("/BlankMap-World6.svg").toString());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error loading svg background map:\n" + ex.toString(), "WoS Error", 0);
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.label = new Label();
        this.btnMaximize = new JButton();
        this.zoomIn = new JButton();
        this.zoomOut = new JButton();
        this.btnExport = new JButton();
        this.btnClose = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                MapDialog.this.formWindowActivated(evt);
            }

            public void windowClosing(WindowEvent evt) {
                MapDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.add((Component)this.jPanel1, "Center");
        this.jPanel3.setLayout(new GridLayout(1, 0));
        this.jPanel3.add(this.label);
        this.btnMaximize.setIcon(new ImageIcon(this.getClass().getResource("/full.gif")));
        this.btnMaximize.setText("Full screen");
        this.btnMaximize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MapDialog.this.btnMaximizeActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnMaximize);
        this.zoomIn.setIcon(new ImageIcon(this.getClass().getResource("/zin.gif")));
        this.zoomIn.setLabel("Zoom In");
        this.jPanel3.add(this.zoomIn);
        this.zoomOut.setIcon(new ImageIcon(this.getClass().getResource("/zout.gif")));
        this.zoomOut.setLabel("Zoom out");
        this.jPanel3.add(this.zoomOut);
        this.btnExport.setIcon(new ImageIcon(this.getClass().getResource("/export.gif")));
        this.btnExport.setLabel("Export...");
        this.btnExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MapDialog.this.btnExportActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnExport);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/exit.gif")));
        this.btnClose.setLabel("Close");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MapDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnClose);
        this.add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void btnMaximizeActionPerformed(ActionEvent evt) {
        this.setSize(MainForm.theMainForm.getWidth(), MainForm.theMainForm.getHeight());
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(new MyFilter());
            fc.setFileSelectionMode(0);
            if (fc.showOpenDialog(this) == 0) {
                this.svgCanvas.setCursor(Cursor.getPredefinedCursor(3));
                BufferedImage bi = this.svgCanvas.getOffScreen();
                File f = fc.getSelectedFile();
                String fPath = f.getPath();
                if (!fPath.endsWith(".png")) {
                    fPath = fPath + ".png";
                }
                ImageIO.write((RenderedImage)bi, "png", new FileOutputStream(fPath));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error exporting image:\n" + ex.toString(), "WoS Error", 0);
            ex.printStackTrace();
        }
        this.svgCanvas.setCursor(Cursor.getDefaultCursor());
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void fillMap() {
        block6: {
            try {
                Graphics grp = this.svgCanvas.getGraphics();
                AffineTransform at = this.svgCanvas.getViewBoxTransform();
                ((Graphics2D)grp).setTransform(at);
                BufferedImage bi = this.svgCanvas.getOffScreen();
                this.svgCanvas.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = 0; i < this.wosDocData.getWosValueSet().size(); ++i) {
                    if (demoVersion && i > demoCtryNo - 1) continue;
                    WoSDocValue wosDocValue = this.wosDocData.getWosValueSet().get(i);
                    Entity entity = wosDocValue.getEntity();
                    int targetColor = this.findColor(wosDocValue.getValue());
                    if (entity instanceof Country) {
                        this.fillCountry(bi, at, (Country)entity, targetColor);
                        continue;
                    }
                    if (entity instanceof Group) {
                        this.fillGroup(bi, at, (Group)entity, targetColor);
                        continue;
                    }
                    throw new Exception("Unknown entity type");
                }
                Graphics2D grpLegend = bi.createGraphics();
                this.drawLegend(grpLegend);
                grpLegend.dispose();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.noRetries >= 3) break block6;
                ++this.noRetries;
                if (this.lastZoom == -1) {
                    this.zoomIn.doClick();
                }
                if (this.lastZoom != 1) break block6;
                this.zoomOut.doClick();
            }
        }
        this.noRetries = 0;
        this.svgCanvas.repaint();
        this.svgCanvas.setCursor(Cursor.getDefaultCursor());
    }

    private void fillCountry(BufferedImage bi, AffineTransform at, Country ctry, int crtColor) {
        for (int p = 0; p < ctry.getPoints().size(); ++p) {
            this.floodFill(bi, at, ctry.getPoints().get(p), crtColor);
        }
    }

    private void fillGroup(BufferedImage bi, AffineTransform at, Group grp, int crtColor) {
        for (int g = 0; g < grp.getCountries().size(); ++g) {
            this.fillCountry(bi, at, grp.getCountries().get(g), crtColor);
        }
    }

    private int findColor(double value) throws Exception {
        int scaleColor = this.wosDocData.getScaleColor();
        int retColor = 0;
        int minColor = 230;
        int maxColor = -200;
        int crtColor = -1;
        if (!this.rangeMode) {
            if (this.colorNo == 1) {
                crtColor = 0;
            } else {
                int idxColor = -1;
                for (int i = 0; i < this.distinctVal.size(); ++i) {
                    if (value != this.distinctVal.get(i).getValue()) continue;
                    idxColor = i;
                    break;
                }
                if (idxColor < 0) {
                    throw new Exception("Cannot resolve color");
                }
                crtColor = minColor - (minColor - maxColor) * idxColor / (this.colorNo - 1);
            }
        } else {
            double dRangeNo = (double)this.colorNo * (value - this.minValue) / (this.maxValue - this.minValue);
            int rangeNo = (int)dRangeNo;
            if (rangeNo > this.colorNo - 1) {
                rangeNo = this.colorNo - 1;
            }
            crtColor = minColor - rangeNo * (minColor - maxColor) / (this.colorNo - 1);
        }
        int alterMainColor = 0;
        if (crtColor < 0) {
            alterMainColor = crtColor;
            crtColor = 0;
        }
        if (scaleColor == WoSDocData.RED) {
            retColor = new Color(255 + alterMainColor, crtColor, crtColor).getRGB();
        } else if (scaleColor == WoSDocData.GREEN) {
            retColor = new Color(crtColor, 255 + alterMainColor, crtColor).getRGB();
        } else if (scaleColor == WoSDocData.BLUE) {
            retColor = new Color(crtColor, crtColor, 255 + alterMainColor).getRGB();
        } else if (scaleColor == WoSDocData.YELLOW) {
            retColor = new Color(255 + alterMainColor, 255 + alterMainColor, crtColor).getRGB();
        } else if (scaleColor == WoSDocData.PINK) {
            retColor = new Color(255 + alterMainColor, crtColor, 255 + alterMainColor).getRGB();
        } else if (scaleColor == WoSDocData.CYAN) {
            retColor = new Color(crtColor, 255 + alterMainColor, 255 + alterMainColor).getRGB();
        } else {
            throw new Exception("Cannot resolve color");
        }
        return retColor;
    }

    private void floodFill(BufferedImage bi, AffineTransform at, Point2D pLogic, int targetValue) {
        Point2D pScreen = at.transform(pLogic, null);
        int x = (int)pScreen.getX();
        int y = (int)pScreen.getY();
        int inc = 1;
        int numberOfRows = this.svgCanvas.getHeight();
        int pixelsPerRow = this.svgCanvas.getWidth();
        if (x < 0 || y < 0 || x > pixelsPerRow || y > numberOfRows) {
            return;
        }
        Point tmp = new Point(x, y);
        int oldValue = bi.getRGB(x, y);
        if (oldValue != -4605511 || oldValue == targetValue) {
            return;
        }
        Vector<Point> searchVector = new Vector<Point>();
        searchVector.add(tmp);
        while (searchVector.size() > 0) {
            Point position = (Point)searchVector.firstElement();
            searchVector.remove(0);
            bi.setRGB(position.x, position.y, targetValue);
            Point top = new Point();
            top.x = position.x;
            top.y = position.y - inc;
            if (top.y >= 0 && bi.getRGB(top.x, top.y) == oldValue && !searchVector.contains(top)) {
                searchVector.add(top);
            }
            Point bottom = new Point();
            bottom.x = position.x;
            bottom.y = position.y + inc;
            if (bottom.y < numberOfRows && bi.getRGB(bottom.x, bottom.y) == oldValue && !searchVector.contains(bottom)) {
                searchVector.add(bottom);
            }
            Point right = new Point();
            right.x = position.x + inc;
            right.y = position.y;
            if (right.x < pixelsPerRow && bi.getRGB(right.x, right.y) == oldValue && !searchVector.contains(right)) {
                searchVector.add(right);
            }
            Point left = new Point();
            left.x = position.x - inc;
            left.y = position.y;
            if (left.x >= 0 && bi.getRGB(left.x, left.y) == oldValue && !searchVector.contains(left)) {
                searchVector.add(left);
            }
            Point topright = new Point();
            topright.x = position.x + inc;
            topright.y = position.y - inc;
            if (topright.y >= 0 && topright.x < pixelsPerRow && bi.getRGB(topright.x, topright.y) == oldValue && !searchVector.contains(topright)) {
                searchVector.add(topright);
            }
            Point bottomright = new Point();
            bottomright.x = position.x + inc;
            bottomright.y = position.y + inc;
            if (bottomright.y < numberOfRows && bottomright.x < pixelsPerRow && bi.getRGB(bottomright.x, bottomright.y) == oldValue && !searchVector.contains(bottomright)) {
                searchVector.add(bottomright);
            }
            Point topleft = new Point();
            topleft.x = position.x - inc;
            topleft.y = position.y - inc;
            if (topleft.y >= 0 && topleft.x >= 0 && bi.getRGB(topleft.x, topleft.y) == oldValue && !searchVector.contains(topleft)) {
                searchVector.add(topleft);
            }
            Point bottomleft = new Point();
            bottomleft.x = position.x - inc;
            bottomleft.y = position.y + inc;
            if (bottomleft.y >= numberOfRows || bottomleft.x < 0 || bi.getRGB(bottomleft.x, bottomleft.y) != oldValue || searchVector.contains(bottomleft)) continue;
            searchVector.add(bottomleft);
        }
    }

    private void drawLegend(Graphics grp) {
        try {
            grp.setColor(Color.BLACK);
            ((Graphics2D)grp).setStroke(new BasicStroke(2.0f));
            grp.drawRect(0, 0, this.svgCanvas.getWidth(), this.svgCanvas.getHeight());
            if (!this.wosDocData.isLegend()) {
                return;
            }
            double lgdXPercent = 0.15;
            double lgdYPercent = 0.3;
            int lgdWidth = (int)(lgdXPercent * (double)this.svgCanvas.getWidth());
            int lgdHeight = (int)(lgdYPercent * (double)this.svgCanvas.getHeight());
            int lgdX = 0;
            int lgdY = (int)((1.0 - lgdYPercent) * (double)this.svgCanvas.getHeight());
            grp.setColor(Color.WHITE);
            grp.fillRect(lgdX, lgdY, lgdWidth, lgdHeight);
            grp.setColor(Color.BLACK);
            grp.drawRect(lgdX, lgdY, lgdWidth, lgdHeight);
            double barXPercent = 0.1;
            double barYPercent = 0.1 * (double)this.colorNo;
            if (barYPercent > 0.6) {
                barYPercent = 0.6;
            }
            int crtX = (int)(barXPercent * (double)lgdWidth);
            int barWidth = (int)((0.4 - barXPercent) * (double)lgdWidth);
            int barHeight = (int)(barYPercent * (double)lgdHeight);
            Font crtFont = grp.getFont();
            double fontPercent = 0.6;
            int fontSize = (int)(fontPercent * (double)barHeight / (double)this.colorNo);
            Font newFont = new Font(crtFont.getName(), crtFont.getStyle(), fontSize);
            grp.setFont(newFont);
            for (int i = 0; i < this.colorNo; ++i) {
                int crtY = lgdY + (int)((1.0 - barYPercent) / 2.0 * (double)lgdHeight) + i * barHeight / this.colorNo;
                double crtVal = 0.0;
                double leftVal = 0.0;
                double rightVal = 0.0;
                if (!this.rangeMode) {
                    crtVal = this.distinctVal.get(i).getValue();
                } else {
                    leftVal = this.minValue + (double)i * ((this.maxValue - this.minValue) / (double)this.colorNo);
                    rightVal = this.minValue + (double)(i + 1) * ((this.maxValue - this.minValue) / (double)this.colorNo);
                    crtVal = this.minValue + (this.maxValue - this.minValue) / (double)this.colorNo * (0.5 + (double)i);
                }
                grp.setColor(new Color(this.findColor(crtVal)));
                grp.fillRect(crtX, crtY, barWidth, barHeight / this.colorNo);
                String barText = "";
                barText = !this.rangeMode ? WoSDocValue.convertValueToString(crtVal) : WoSDocValue.convertValueToString(leftVal) + " - " + WoSDocValue.convertValueToString(rightVal);
                grp.setColor(Color.BLACK);
                int txtX = crtX + barWidth;
                int txtY = crtY + fontSize + (int)((double)(barHeight / this.colorNo - fontSize) / 2.0);
                grp.drawString(barText, txtX += (int)(0.05 * (double)(lgdWidth - crtX)), txtY);
            }
            grp.setColor(Color.BLACK);
            int crtY = lgdY + (int)((1.0 - barYPercent) / 2.0 * (double)lgdHeight) + barHeight;
            int txtX = crtX + barWidth;
            int txtY = crtY + fontSize + (int)((double)(barHeight / this.colorNo - fontSize) / 2.0);
            grp.drawString(this.wosDocData.getMeasureUnit(), txtX += (int)(0.05 * (double)(lgdWidth - crtX)), txtY);
            int newFontSize = (int)(0.9 * (double)fontSize);
            newFont = new Font(crtFont.getName(), 2, newFontSize);
            grp.setFont(newFont);
            grp.drawString("Produced by World of Statistics", 10, this.svgCanvas.getHeight() - 10);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class MyFilter
    extends FileFilter {
        private MyFilter() {
        }

        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.endsWith(".png") || file.isDirectory();
        }

        public String getDescription() {
            return "*.png";
        }
    }
}

