/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WoSAppData {
    public static WoSAppData theAppData = new WoSAppData();
    private ArrayList<Country> wosCountries = new ArrayList();
    private ArrayList<Group> wosGroups = new ArrayList();

    public ArrayList<Country> getWosCountries() {
        return this.wosCountries;
    }

    public void setWosCountries(ArrayList<Country> wosCountries) {
    }

    public ArrayList<Group> getWosGroups() {
        return this.wosGroups;
    }

    public void setWosGroups(ArrayList<Group> wosGroups) {
    }

    public boolean loadCountries() {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader("Countries.txt"));
            while ((str = in.readLine()) != null) {
                boolean newCtry;
                String[] elms = str.split("\t");
                String code = elms[0];
                String name = elms[1];
                int x = Integer.valueOf(elms[2]);
                int y = Integer.valueOf(elms[3]);
                Point2D.Double point = new Point2D.Double(x, y);
                Country ctry = this.findCountry(code);
                boolean bl = newCtry = ctry == null;
                if (ctry == null) {
                    ctry = new Country();
                    ctry.setCode(code);
                    ctry.setName(name);
                }
                ctry.getPoints().add(point);
                if (!newCtry) continue;
                this.wosCountries.add(ctry);
            }
            in.close();
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot load countries. Program aborted!", "WoS Error", 0);
            ex.printStackTrace();
            return false;
        }
    }

    public boolean loadGroups() {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader("Countrygroups.txt"));
            while ((str = in.readLine()) != null) {
                boolean newgroup;
                String[] elms = str.split("\t");
                String grpCode = elms[0];
                String grpName = elms[1];
                String ctryCode = elms[2];
                Group group = this.findGroup(grpCode);
                Country ctry = this.findCountry(ctryCode);
                if (ctry == null) {
                    throw new Exception("country " + ctryCode + " not found when loading groups!");
                }
                boolean bl = newgroup = group == null;
                if (group == null) {
                    group = new Group();
                    group.setCode(grpCode);
                    group.setName(grpName);
                }
                group.getCountries().add(ctry);
                if (!newgroup) continue;
                this.wosGroups.add(group);
            }
            in.close();
            return true;
        }
        catch (FileNotFoundException nfex) {
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot load groups. Program aborted!", "WoS Error", 0);
            System.out.print(ex.toString() + "\n");
            return false;
        }
    }

    public Country findCountry(String code) {
        for (int i = 0; i < this.wosCountries.size(); ++i) {
            if (!this.wosCountries.get(i).getCode().toUpperCase().equals(code.toUpperCase())) continue;
            return this.wosCountries.get(i);
        }
        return null;
    }

    public Group findGroup(String code) {
        for (int i = 0; i < this.wosGroups.size(); ++i) {
            if (!this.wosGroups.get(i).getCode().toUpperCase().equals(code.toUpperCase())) continue;
            return this.wosGroups.get(i);
        }
        return null;
    }

    public Entity findCountryOrGroupByName(String name) {
        for (Country ctry : this.wosCountries) {
            if (!ctry.getName().toUpperCase().equals(name.toUpperCase())) continue;
            return ctry;
        }
        for (Group grp : this.wosGroups) {
            if (!grp.getName().toUpperCase().equals(name.toUpperCase())) continue;
            return grp;
        }
        return null;
    }

    public void storeGroups() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("Countrygroups.txt"));
            for (Group grp : this.getWosGroups()) {
                for (Country ctry : grp.getCountries()) {
                    out.write(grp.getCode() + "\t" + grp.getName() + "\t" + ctry.getCode() + "\n");
                }
            }
            out.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot store groups.", "WoS Error", 0);
            System.out.print(ex.toString() + "\n");
        }
    }

    public static void checkLicense() {
        boolean valid = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader("wos.lic"));
            String str = in.readLine();
            in.close();
            StringBuffer strMonth = new StringBuffer();
            strMonth.append(str.charAt(4));
            strMonth.append(str.charAt(9));
            StringBuffer strDay = new StringBuffer();
            strDay.append(str.charAt(13));
            strDay.append(str.charAt(7));
            StringBuffer strYear = new StringBuffer();
            strYear.append(str.charAt(17));
            strYear.append(str.charAt(15));
            strYear.append(str.charAt(2));
            strYear.append(str.charAt(11));
            int year = Integer.parseInt(strYear.toString());
            int month = Integer.parseInt(strMonth.toString());
            int day = Integer.parseInt(strDay.toString());
            if (year > 2015 || month < 1 || month > 12 || day < 1 || day > 31) {
                throw new Exception("Invalid license key.");
            }
            Date now = new Date();
            Date toDate = new Date(year - 1900, month - 1, day);
            if (now.after(toDate)) {
                JOptionPane.showMessageDialog(null, "WoS license has expired!\r\nPlease visit oldlake.brinsker.net to renew your license.", "WoS Information", 1);
                try {
                    new File("wos.lic").delete();
                }
                catch (Exception delFileEx) {}
            } else {
                valid = true;
            }
        }
        catch (FileNotFoundException nfex) {
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot check license.", "WoS Error", 0);
            System.out.print(ex.toString() + "\n");
        }
        MapDialog.demoVersion = !valid;
    }
}

