/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WoSDocData {
    public static int RED = 0;
    public static int GREEN = 1;
    public static int BLUE = 2;
    public static int YELLOW = 3;
    public static int PINK = 4;
    public static int CYAN = 5;
    private String measureUnit;
    private int scaleColor;
    private ArrayList<WoSDocValue> wosValueSet = new ArrayList();
    private File file;
    private boolean legend;

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public int getScaleColor() {
        return this.scaleColor;
    }

    public void setScaleColor(int scaleColor) {
        this.scaleColor = scaleColor;
        if (this.scaleColor < RED || this.scaleColor > CYAN) {
            this.scaleColor = RED;
        }
    }

    public ArrayList<WoSDocValue> getWosValueSet() {
        return this.wosValueSet;
    }

    public double getMinValue() {
        if (this.getWosValueSet().size() == 0) {
            return 0.0;
        }
        double minValue = this.getWosValueSet().get(0).getValue();
        for (int i = 0; i < this.getWosValueSet().size(); ++i) {
            if (!(this.getWosValueSet().get(i).getValue() < minValue)) continue;
            minValue = this.getWosValueSet().get(i).getValue();
        }
        return minValue;
    }

    public double getMaxValue() {
        if (this.getWosValueSet().size() == 0) {
            return 0.0;
        }
        double maxValue = this.getWosValueSet().get(0).getValue();
        for (int i = 0; i < this.getWosValueSet().size(); ++i) {
            if (!(this.getWosValueSet().get(i).getValue() > maxValue)) continue;
            maxValue = this.getWosValueSet().get(i).getValue();
        }
        return maxValue;
    }

    public Vector<WoSDocValue> getDistinctValues() {
        Vector<WoSDocValue> distinctVal = new Vector<WoSDocValue>();
        for (int i = 0; i < this.getWosValueSet().size(); ++i) {
            WoSDocValue wosVal = this.getWosValueSet().get(i);
            boolean found = false;
            for (int j = 0; j < distinctVal.size(); ++j) {
                if (distinctVal.get(j).getValue() != wosVal.getValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            distinctVal.add(wosVal);
        }
        for (int l = 0; l < distinctVal.size(); ++l) {
            for (int m = l + 1; m < distinctVal.size(); ++m) {
                WoSDocValue first = distinctVal.get(l);
                WoSDocValue second = distinctVal.get(m);
                if (!(first.getValue() > second.getValue())) continue;
                WoSDocValue tmp = first;
                distinctVal.set(l, second);
                distinctVal.set(m, tmp);
            }
        }
        return distinctVal;
    }

    public void setWosValueSet(ArrayList<WoSDocValue> wosDataSet) {
    }

    public boolean load() {
        this.file = null;
        String filename = "";
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            MyFilter filter = new MyFilter();
            chooser.setFileFilter(filter);
            int ret = chooser.showOpenDialog(null);
            if (ret == 0) {
                String str;
                this.file = chooser.getSelectedFile();
                filename = this.file.getName();
                BufferedReader in = new BufferedReader(new FileReader(chooser.getSelectedFile()));
                int i = 0;
                while ((str = in.readLine()) != null) {
                    if (i == 0) {
                        this.setMeasureUnit(str);
                    } else if (i == 1) {
                        this.setScaleColor(Integer.valueOf(str));
                    } else if (i == 2) {
                        this.setLegend(Integer.valueOf(str) > 0);
                    } else {
                        this.readDataLine(str);
                    }
                    ++i;
                }
                in.close();
                return true;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot load document " + filename + "!", "WoS Error", 0);
            ex.printStackTrace();
        }
        return false;
    }

    private void readDataLine(String str) throws Exception {
        String[] elms = str.split("\t");
        String entityCode = elms[0];
        double value = Double.valueOf(elms[1]);
        Entity entity = entityCode.length() == 2 ? WoSAppData.theAppData.findCountry(entityCode) : WoSAppData.theAppData.findGroup(entityCode);
        if (entity == null) {
            entity = WoSAppData.theAppData.findCountryOrGroupByName(entityCode);
        }
        if (entity == null) {
            return;
        }
        WoSDocValue wosDocValue = new WoSDocValue();
        wosDocValue.setEntity(entity);
        wosDocValue.setValue(value);
        this.getWosValueSet().add(wosDocValue);
    }

    public void importWosData() {
        try {
            TextTransfer tt = new TextTransfer();
            String inputStr = tt.getClipboardContents();
            if (inputStr == null || inputStr.length() == 0) {
                JOptionPane.showMessageDialog(null, "Cannot import data. Clipboard is empty!", "WoS Error", 0);
                return;
            }
            String patternStr = "^(.*)$";
            Pattern pattern = Pattern.compile(patternStr, 8);
            Matcher matcher = pattern.matcher(inputStr);
            while (matcher.find()) {
                String line = matcher.group(1);
                this.readDataLine(line);
            }
            tt.setClipboardContents("");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot import data from clipboard!\r\nThe clipboard has no data or contains data with invalid format. The correct format is:\r\n<Code>TAB<Value>\r\n\r\nIf you have copied data from Excel, make sure you have copied the code and value columns without headers.", "WoS Error", 0);
            ex.printStackTrace();
        }
    }

    public void store() {
        try {
            if (this.file == null) {
                JFileChooser fc = new JFileChooser();
                fc.addChoosableFileFilter(new MyFilter());
                fc.setFileSelectionMode(0);
                if (fc.showOpenDialog(null) == 0) {
                    this.file = fc.getSelectedFile();
                    String fPath = this.file.getPath();
                    if (!fPath.endsWith(".wos")) {
                        fPath = fPath + ".wos";
                    }
                    this.file = new File(fPath);
                }
            }
            if (this.file == null) {
                return;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
            out.write(this.getMeasureUnit() + "\n");
            out.write(Integer.toString(this.getScaleColor()) + "\n");
            out.write(Integer.toString(this.isLegend() ? 1 : 0) + "\n");
            for (WoSDocValue wosDocVal : this.getWosValueSet()) {
                out.write(wosDocVal.getEntity().getCode() + "\t" + Double.toString(wosDocVal.getValue()) + "\n");
            }
            out.close();
        }
        catch (Exception ex) {
            String filename = this.file != null ? this.file.getName() : "";
            JOptionPane.showMessageDialog(null, "Cannot store document " + filename + "!\nError:\n" + ex.toString(), "WoS Error", 0);
            ex.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File _file) {
        this.file = _file;
    }

    public boolean isLegend() {
        return this.legend;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    protected static class MyFilter
    extends FileFilter {
        protected MyFilter() {
        }

        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.endsWith(".wos") || file.isDirectory();
        }

        public String getDescription() {
            return "*.wos";
        }
    }
}

