/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class WoSDocumentForm
extends JFrame
implements ListSelectionListener {
    private JButton btnAdd;
    private JButton btnDrawMap;
    private JButton btnEdit;
    private JButton btnExit;
    private JButton btnImport;
    private JButton btnRemove;
    private JButton btnStore;
    private Checkbox chkLegend;
    private Choice cmbColor;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private Label label1;
    private Label label2;
    private Label label3;
    private TextField lblColor;
    private Panel panel1;
    private Panel panel10;
    private Panel panel11;
    private Panel panel2;
    private Panel panel3;
    private Panel panel4;
    private Panel panel5;
    private Panel panel6;
    private Panel panel7;
    private Panel panel8;
    private TextField txtMeasUnit;
    private WoSDocData wosDocData;
    private boolean dataChanged = false;

    public WoSDocumentForm(WoSDocData docData) {
        this.wosDocData = docData;
        this.initComponents();
        this.setSize(MainForm.theMainForm.getWidth(), MainForm.theMainForm.getHeight());
        this.setTitle(docData.getFile() != null ? docData.getFile().getName() : "<<New wos document>>");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/map.gif")).getImage());
        MyTableModel myTableModel = new MyTableModel(this, null, new String[]{"Code (Name)", "Value"});
        this.jTable1.setModel(myTableModel);
        this.jTable1.getSelectionModel().setSelectionMode(0);
        this.jTable1.getSelectionModel().addListSelectionListener(this);
        this.btnAdd.setMnemonic(65);
        this.btnEdit.setMnemonic(69);
        this.btnRemove.setMnemonic(82);
        this.btnImport.setMnemonic(73);
        this.cmbColor.addItem("Red");
        this.cmbColor.addItem("Green");
        this.cmbColor.addItem("Blue");
        this.cmbColor.addItem("Yellow");
        this.cmbColor.addItem("Pink");
        this.cmbColor.addItem("Cyan");
        this.putValues();
    }

    private void initComponents() {
        this.panel3 = new Panel();
        this.panel2 = new Panel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.panel5 = new Panel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnImport = new JButton();
        this.panel4 = new Panel();
        this.panel7 = new Panel();
        this.panel10 = new Panel();
        this.label2 = new Label();
        this.txtMeasUnit = new TextField();
        this.panel11 = new Panel();
        this.label3 = new Label();
        this.cmbColor = new Choice();
        this.lblColor = new TextField();
        this.panel1 = new Panel();
        this.chkLegend = new Checkbox();
        this.panel8 = new Panel();
        this.btnDrawMap = new JButton();
        this.btnStore = new JButton();
        this.btnExit = new JButton();
        this.panel6 = new Panel();
        this.label1 = new Label();
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        this.setDefaultCloseOperation(3);
        this.panel3.setLayout(new GridLayout(2, 1, 4, 4));
        this.panel2.setLayout(new GridBagLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        this.panel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panel5.setLayout(new GridLayout(4, 0, 2, 0));
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/add.gif")));
        this.btnAdd.setLabel("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnAddActionPerformed(evt);
            }
        });
        this.panel5.add(this.btnAdd);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/edit.gif")));
        this.btnEdit.setLabel("Edit");
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnEditActionPerformed(evt);
            }
        });
        this.panel5.add(this.btnEdit);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/remove.gif")));
        this.btnRemove.setLabel("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnRemoveActionPerformed(evt);
            }
        });
        this.panel5.add(this.btnRemove);
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/import.gif")));
        this.btnImport.setText("Import from cllipboard");
        this.btnImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnImportActionPerformed(evt);
            }
        });
        this.panel5.add(this.btnImport);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        this.panel2.add((Component)this.panel5, gridBagConstraints);
        this.panel3.add(this.panel2);
        this.panel4.setLayout(new GridLayout(3, 1, 0, 4));
        this.panel7.setLayout(new GridLayout(1, 2, 4, 0));
        this.panel10.setLayout(new GridBagLayout());
        this.label2.setText("Measuring unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        this.panel10.add((Component)this.label2, gridBagConstraints);
        this.txtMeasUnit.setText("            ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.panel10.add((Component)this.txtMeasUnit, gridBagConstraints);
        this.panel7.add(this.panel10);
        this.panel11.setLayout(new GridBagLayout());
        this.label3.setText("Scale color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panel11.add((Component)this.label3, gridBagConstraints);
        this.cmbColor.setBackground(new Color(196, 196, 196));
        this.cmbColor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                WoSDocumentForm.this.cmbColorItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        this.panel11.add((Component)this.cmbColor, gridBagConstraints);
        this.lblColor.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panel11.add((Component)this.lblColor, gridBagConstraints);
        this.panel7.add(this.panel11);
        this.panel4.add(this.panel7);
        this.panel1.setLayout(new BorderLayout());
        this.chkLegend.setLabel("Show legend");
        this.panel1.add((Component)this.chkLegend, "West");
        this.panel4.add(this.panel1);
        this.panel8.setLayout(new GridBagLayout());
        this.btnDrawMap.setIcon(new ImageIcon(this.getClass().getResource("/map.gif")));
        this.btnDrawMap.setLabel(" Draw Map");
        this.btnDrawMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnDrawMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.panel8.add((Component)this.btnDrawMap, gridBagConstraints);
        this.btnStore.setIcon(new ImageIcon(this.getClass().getResource("/store.gif")));
        this.btnStore.setLabel("Store");
        this.btnStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnStoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel8.add((Component)this.btnStore, gridBagConstraints);
        this.btnExit.setIcon(new ImageIcon(this.getClass().getResource("/exit.gif")));
        this.btnExit.setLabel("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WoSDocumentForm.this.btnExitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel8.add((Component)this.btnExit, gridBagConstraints);
        this.panel4.add(this.panel8);
        this.panel3.add(this.panel4);
        this.getContentPane().add((Component)this.panel3, "Center");
        this.label1.setFont(new Font("Dialog", 1, 12));
        this.label1.setText("Statistical data");
        this.panel6.add(this.label1);
        this.getContentPane().add((Component)this.panel6, "North");
        this.pack();
    }

    private void cmbColorItemStateChanged(ItemEvent evt) {
        switch (this.cmbColor.getSelectedIndex()) {
            case 0: {
                this.lblColor.setBackground(Color.RED);
                break;
            }
            case 1: {
                this.lblColor.setBackground(Color.GREEN);
                break;
            }
            case 2: {
                this.lblColor.setBackground(Color.BLUE);
                break;
            }
            case 3: {
                this.lblColor.setBackground(Color.YELLOW);
                break;
            }
            case 4: {
                this.lblColor.setBackground(Color.PINK);
                break;
            }
            case 5: {
                this.lblColor.setBackground(Color.CYAN);
                break;
            }
        }
        this.dataChanged = true;
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        boolean canExit = true;
        if (this.dataChanged) {
            boolean bl = canExit = JOptionPane.showConfirmDialog(this, "Data has not been saved. Are you sure you want to exit?", "WoS Question", 0, 3, null) == 0;
        }
        if (canExit) {
            this.hide();
            this.dispose();
        }
    }

    private void btnStoreActionPerformed(ActionEvent evt) {
        this.readValues();
        this.wosDocData.store();
        this.setTitle(this.wosDocData.getFile() != null ? this.wosDocData.getFile().getName() : "<<New wos document>>");
        this.dataChanged = false;
    }

    private void btnDrawMapActionPerformed(ActionEvent evt) {
        this.readValues();
        MapDialog mapDialog = new MapDialog((Frame)this, this.wosDocData);
        mapDialog.setVisible(true);
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        this.wosDocData.importWosData();
        this.fillTable();
        this.dataChanged = true;
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int idx = this.jTable1.getSelectedRow();
        this.wosDocData.getWosValueSet().remove(idx);
        this.fillTable();
        this.dataChanged = true;
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        int idx = this.jTable1.getSelectedRow();
        WoSDocValue wdd = this.wosDocData.getWosValueSet().get(idx);
        WoSDocValue editVal = new WoSDocValue(wdd);
        EditValueDialog evd = new EditValueDialog((Frame)this, editVal, this.wosDocData);
        evd.setVisible(true);
        if (evd.isOk()) {
            this.wosDocData.getWosValueSet().set(idx, editVal);
            this.fillTable();
            this.jTable1.getSelectionModel().setSelectionInterval(idx, idx);
        }
        this.dataChanged = true;
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        WoSDocValue newVal = new WoSDocValue();
        EditValueDialog evd = new EditValueDialog((Frame)this, newVal, this.wosDocData);
        evd.setVisible(true);
        if (evd.isOk()) {
            this.wosDocData.getWosValueSet().add(newVal);
            this.fillTable();
        }
        this.dataChanged = true;
    }

    public WoSDocData getWoSDocData() {
        return this.wosDocData;
    }

    public void fillTable() {
        ((DefaultTableModel)this.jTable1.getModel()).setRowCount(0);
        int i = 0;
        for (i = 0; i < this.wosDocData.getWosValueSet().size(); ++i) {
            WoSDocValue val = this.wosDocData.getWosValueSet().get(i);
            ((DefaultTableModel)this.jTable1.getModel()).addRow(new Object[]{val.getEntity(), val.getValue()});
        }
    }

    private void putValues() {
        this.fillTable();
        this.cmbColor.select(this.wosDocData.getScaleColor());
        this.cmbColorItemStateChanged(null);
        this.txtMeasUnit.setText(this.wosDocData.getMeasureUnit());
        this.chkLegend.setState(this.wosDocData.isLegend());
    }

    private void readValues() {
        this.wosDocData.setScaleColor(this.cmbColor.getSelectedIndex());
        this.wosDocData.setMeasureUnit(this.txtMeasUnit.getText());
        this.wosDocData.setLegend(this.chkLegend.getState());
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() != this.jTable1.getSelectionModel()) {
            return;
        }
        int idx = -1;
        if (!e.getValueIsAdjusting()) {
            idx = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
        }
        this.btnEdit.setEnabled(idx >= 0);
        this.btnRemove.setEnabled(idx >= 0);
    }
}

