/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptEventWrapper;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.EventListenerInitializer;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    public static final String INLINE_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.inline.script.description";
    public static final String EVENT_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.event.script.description";
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected static final String APPLICATION_ECMASCRIPT = "application/ecmascript";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;
    protected Set languages = new HashSet();
    protected Interpreter interpreter;

    public static boolean isDynamicDocument(BridgeContext bridgeContext, Document document) {
        Element element = document.getDocumentElement();
        if (element != null && "http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(bridgeContext, document.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(BridgeContext bridgeContext, Element element) {
        List list = bridgeContext.getBridgeExtensions(element.getOwnerDocument());
        return BaseScriptingEnvironment.isDynamicElement(element, bridgeContext, list);
    }

    public static boolean isDynamicElement(Element element, BridgeContext bridgeContext, List list) {
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (BridgeExtension)iterator.next();
            if (!object.isDynamicElement(element)) continue;
            return true;
        }
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
        }
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1 || !BaseScriptingEnvironment.isDynamicElement(bridgeContext, (Element)object)) continue;
            return true;
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
        this.document = bridgeContext.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public Interpreter getInterpreter() {
        if (this.interpreter != null) {
            return this.interpreter;
        }
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        return this.getInterpreter(string);
    }

    public Interpreter getInterpreter(String string) {
        this.interpreter = this.bridgeContext.getInterpreter(string);
        if (this.interpreter == null) {
            if (this.languages.contains(string)) {
                return null;
            }
            this.languages.add(string);
            return null;
        }
        if (!this.languages.contains(string)) {
            this.languages.add(string);
            this.initializeEnvironment(this.interpreter, string);
        }
        return this.interpreter;
    }

    public void initializeEnvironment(Interpreter interpreter, String string) {
        interpreter.bindObject("window", this.createWindow(interpreter, string));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            AbstractElement abstractElement = (AbstractElement)nodeList.item(i);
            String string = abstractElement.getAttributeNS(null, "type");
            if (string.length() == 0) {
                string = "text/ecmascript";
            }
            if (string.equals("application/java-archive")) {
                try {
                    Object object8;
                    object7 = XLinkSupport.getXLinkHref(abstractElement);
                    object6 = new ParsedURL(abstractElement.getBaseURI(), (String)object7);
                    this.checkCompatibleScriptURL(string, (ParsedURL)object6);
                    object5 = null;
                    try {
                        object5 = new URL(this.docPURL.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    object4 = new DocumentJarClassLoader(new URL(((ParsedURL)object6).toString()), (URL)object5);
                    object3 = ((URLClassLoader)object4).findResource("META-INF/MANIFEST.MF");
                    if (object3 == null) continue;
                    object2 = new Manifest(((URL)object3).openStream());
                    object = ((Manifest)object2).getMainAttributes().getValue("Script-Handler");
                    if (object != null) {
                        object8 = (ScriptHandler)((ClassLoader)object4).loadClass((String)object).newInstance();
                        if (window == null) {
                            window = this.createWindow();
                        }
                        object8.run(this.document, window);
                    }
                    if ((object = ((Manifest)object2).getMainAttributes().getValue("SVG-Handler-Class")) == null) continue;
                    object8 = (EventListenerInitializer)((ClassLoader)object4).loadClass((String)object).newInstance();
                    if (window == null) {
                        window = this.createWindow();
                    }
                    object8.initializeEventListeners((SVGDocument)this.document);
                }
                catch (Exception exception) {
                    if (this.userAgent == null) continue;
                    this.userAgent.displayError(exception);
                }
                continue;
            }
            object7 = this.getInterpreter(string);
            if (object7 == null) continue;
            try {
                Object object9;
                Object object10;
                object6 = XLinkSupport.getXLinkHref(abstractElement);
                object4 = null;
                object5 = null;
                if (((String)object6).length() > 0) {
                    object4 = object6;
                    object3 = new ParsedURL(abstractElement.getBaseURI(), (String)object6);
                    this.checkCompatibleScriptURL(string, (ParsedURL)object3);
                    object2 = ((ParsedURL)object3).openStream();
                    object = ((ParsedURL)object3).getContentTypeMediaType();
                    String string2 = ((ParsedURL)object3).getContentTypeCharset();
                    if (string2 != null) {
                        try {
                            object5 = new InputStreamReader((InputStream)object2, string2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            string2 = null;
                        }
                    }
                    if (object5 == null) {
                        if (APPLICATION_ECMASCRIPT.equals(object)) {
                            if (((ParsedURL)object3).hasContentTypeParameter("version")) continue;
                            object10 = new PushbackInputStream((InputStream)object2, 8);
                            object9 = new byte[4];
                            int n2 = ((FilterInputStream)object10).read((byte[])object9);
                            if (n2 > 0) {
                                ((PushbackInputStream)object10).unread((byte[])object9, 0, n2);
                                if (n2 >= 2) {
                                    if (object9[0] == -1 && object9[1] == -2) {
                                        if (n2 >= 4 && object9[2] == false && object9[3] == false) {
                                            string2 = "UTF32-LE";
                                            ((PushbackInputStream)object10).skip(4L);
                                        } else {
                                            string2 = "UTF-16LE";
                                            ((PushbackInputStream)object10).skip(2L);
                                        }
                                    } else if (object9[0] == -2 && object9[1] == -1) {
                                        string2 = "UTF-16BE";
                                        ((PushbackInputStream)object10).skip(2L);
                                    } else if (n2 >= 3 && object9[0] == -17 && object9[1] == -69 && object9[2] == -65) {
                                        string2 = "UTF-8";
                                        ((PushbackInputStream)object10).skip(3L);
                                    } else if (n2 >= 4 && object9[0] == false && object9[1] == false && object9[2] == -2 && object9[3] == -1) {
                                        string2 = "UTF-32BE";
                                        ((PushbackInputStream)object10).skip(4L);
                                    }
                                }
                                if (string2 == null) {
                                    string2 = "UTF-8";
                                }
                            }
                            object5 = new InputStreamReader((InputStream)object10, string2);
                        } else {
                            object5 = new InputStreamReader((InputStream)object2);
                        }
                    }
                } else {
                    this.checkCompatibleScriptURL(string, this.docPURL);
                    object3 = this.bridgeContext.getDocumentLoader();
                    object2 = abstractElement;
                    object = (SVGDocument)object2.getOwnerDocument();
                    int n3 = ((DocumentLoader)object3).getLineNumber(abstractElement);
                    object4 = Messages.formatMessage(INLINE_SCRIPT_DESCRIPTION, new Object[]{object.getURL(), "<" + abstractElement.getNodeName() + ">", new Integer(n3)});
                    if (object10 == null) continue;
                    object9 = new StringBuffer();
                    for (object10 = abstractElement.getFirstChild(); object10 != null; object10 = object10.getNextSibling()) {
                        if (object10.getNodeType() != 4 && object10.getNodeType() != 3) continue;
                        object9.append(object10.getNodeValue());
                    }
                    object5 = new StringReader(object9.toString());
                }
                object7.evaluate((Reader)object5, (String)object4);
                continue;
            }
            catch (IOException iOException) {
                if (this.userAgent != null) {
                    this.userAgent.displayError(iOException);
                }
                return;
            }
            catch (InterpreterException interpreterException) {
                System.err.println("InterpExcept: " + interpreterException);
                this.handleInterpreterException(interpreterException);
                return;
            }
            catch (SecurityException securityException) {
                if (this.userAgent == null) continue;
                this.userAgent.displayError(securityException);
            }
        }
    }

    protected void checkCompatibleScriptURL(String string, ParsedURL parsedURL) {
        this.userAgent.checkLoadScript(string, parsedURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        long l = System.currentTimeMillis();
        this.dispatchSVGLoad(sVGSVGElement, true, string);
        this.bridgeContext.getAnimationEngine().start(l);
    }

    protected void dispatchSVGLoad(Element element, boolean bl, String string) {
        Object object;
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            this.dispatchSVGLoad((Element)object, bl, string);
        }
        object = (DocumentEvent)((Object)element.getOwnerDocument());
        AbstractEvent abstractEvent = (AbstractEvent)object.createEvent("SVGEvents");
        String string2 = this.bridgeContext.isSVG12() ? "load" : "SVGLoad";
        abstractEvent.initEventNS("http://www.w3.org/2001/xml-events", string2, false, false);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
        final String string3 = element.getAttributeNS(null, "onload");
        if (string3.length() == 0) {
            nodeEventTarget.dispatchEvent(abstractEvent);
            return;
        }
        final Interpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            nodeEventTarget.dispatchEvent(abstractEvent);
            return;
        }
        if (bl) {
            this.checkCompatibleScriptURL(string, this.docPURL);
            bl = false;
        }
        DocumentLoader documentLoader = this.bridgeContext.getDocumentLoader();
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        int n = documentLoader.getLineNumber(element);
        final String string4 = Messages.formatMessage(EVENT_SCRIPT_DESCRIPTION, new Object[]{sVGDocument.getURL(), "onload", new Integer(n)});
        EventListener eventListener = new EventListener(){

            public void handleEvent(Event event) {
                try {
                    Object object = event instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)event)).getEventObject() : event;
                    interpreter.bindObject(BaseScriptingEnvironment.EVENT_NAME, object);
                    interpreter.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, object);
                    interpreter.evaluate(new StringReader(string3), string4);
                }
                catch (IOException iOException) {
                }
                catch (InterpreterException interpreterException) {
                    BaseScriptingEnvironment.this.handleInterpreterException(interpreterException);
                }
            }
        };
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", string2, eventListener, false, null);
        nodeEventTarget.dispatchEvent(abstractEvent);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", string2, eventListener, false);
    }

    protected void dispatchSVGZoomEvent() {
        if (this.bridgeContext.isSVG12()) {
            this.dispatchSVGDocEvent("zoom");
        } else {
            this.dispatchSVGDocEvent("SVGZoom");
        }
    }

    protected void dispatchSVGScrollEvent() {
        if (this.bridgeContext.isSVG12()) {
            this.dispatchSVGDocEvent("scroll");
        } else {
            this.dispatchSVGDocEvent("SVGScroll");
        }
    }

    protected void dispatchSVGResizeEvent() {
        if (this.bridgeContext.isSVG12()) {
            this.dispatchSVGDocEvent("resize");
        } else {
            this.dispatchSVGDocEvent("SVGResize");
        }
    }

    protected void dispatchSVGDocEvent(String string) {
        SVGSVGElement sVGSVGElement;
        SVGSVGElement sVGSVGElement2 = sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.document);
        AbstractEvent abstractEvent = (AbstractEvent)documentEvent.createEvent("SVGEvents");
        abstractEvent.initEventNS("http://www.w3.org/2001/xml-events", string, false, false);
        sVGSVGElement2.dispatchEvent(abstractEvent);
    }

    protected void handleInterpreterException(InterpreterException interpreterException) {
        if (this.userAgent != null) {
            Exception exception = interpreterException.getException();
            this.userAgent.displayError(exception == null ? interpreterException : exception);
        }
    }

    protected void handleSecurityException(SecurityException securityException) {
        if (this.userAgent != null) {
            this.userAgent.displayError(securityException);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            return null;
        }

        public Object setInterval(Runnable runnable, long l) {
            return null;
        }

        public void clearInterval(Object object) {
        }

        public Object setTimeout(String string, long l) {
            return null;
        }

        public Object setTimeout(Runnable runnable, long l) {
            return null;
        }

        public void clearTimeout(Object object) {
        }

        public Node parseXML(String string, Document document) {
            return null;
        }

        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler) {
            this.getURL(string, uRLResponseHandler, "UTF8");
        }

        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler, String string2) {
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler) {
            this.postURL(string, string2, uRLResponseHandler, "text/plain", null);
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3) {
            this.postURL(string, string2, uRLResponseHandler, string3, null);
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3, String string4) {
        }

        public void alert(String string) {
        }

        public boolean confirm(String string) {
            return false;
        }

        public String prompt(String string) {
            return null;
        }

        public String prompt(String string, String string2) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

