/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.anim.values.AnimatableNumberListValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.AbstractSVGNumberList;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedNumberList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class SVGOMAnimatedNumberList
extends AbstractSVGAnimatedValue
implements SVGAnimatedNumberList {
    protected BaseSVGNumberList baseVal;
    protected AnimSVGNumberList animVal;
    protected boolean changing;
    protected String defaultValue;
    protected boolean emptyAllowed;

    public SVGOMAnimatedNumberList(AbstractElement abstractElement, String string, String string2, String string3, boolean bl) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
        this.emptyAllowed = bl;
    }

    public SVGNumberList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGNumberList();
        }
        return this.baseVal;
    }

    public SVGNumberList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGNumberList();
        }
        return this.animVal;
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGNumberList sVGNumberList = this.getBaseVal();
        int n = sVGNumberList.getNumberOfItems();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = sVGNumberList.getItem(n).getValue();
        }
        return new AnimatableNumberListValue(animationTarget, fArray);
    }

    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableNumberListValue animatableNumberListValue = (AnimatableNumberListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGNumberList();
            }
            this.animVal.setAnimatedValue(animatableNumberListValue.getNumbers());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGNumberList
    extends AbstractSVGNumberList {
        public AnimSVGNumberList() {
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedNumberList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedNumberList.this.element).createSVGException(s, string, objectArray);
        }

        protected Element getElement() {
            return SVGOMAnimatedNumberList.this.element;
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedNumberList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedNumberList.this.getBaseVal().getNumberOfItems();
        }

        public SVGNumber getItem(int n) throws DOMException {
            if (SVGOMAnimatedNumberList.this.hasAnimVal) {
                return super.getItem(n);
            }
            return SVGOMAnimatedNumberList.this.getBaseVal().getItem(n);
        }

        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuffer.toString();
        }

        protected void setAttributeValue(String string) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber initialize(SVGNumber sVGNumber) throws DOMException, SVGException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber replaceItem(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber removeItem(int n) throws DOMException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber appendItem(SVGNumber sVGNumber) throws DOMException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        protected void setAnimatedValue(float[] fArray) {
            int n;
            int n2 = this.itemList.size();
            for (n = 0; n < n2 && n < fArray.length; ++n) {
                AbstractSVGNumberList.SVGNumberItem sVGNumberItem = (AbstractSVGNumberList.SVGNumberItem)this.itemList.get(n);
                sVGNumberItem.value = fArray[n];
            }
            while (n < fArray.length) {
                this.appendItemImpl(new AbstractSVGNumberList.SVGNumberItem(this, fArray[n]));
                ++n;
            }
            while (n2 > fArray.length) {
                this.removeItemImpl(--n2);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem sVGItem) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGNumberList
    extends AbstractSVGNumberList {
        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedNumberList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedNumberList.this.element).createSVGException(s, string, objectArray);
        }

        protected Element getElement() {
            return SVGOMAnimatedNumberList.this.element;
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedNumberList.this.element.getAttributeNodeNS(SVGOMAnimatedNumberList.this.namespaceURI, SVGOMAnimatedNumberList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedNumberList.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedNumberList.this.changing = true;
                SVGOMAnimatedNumberList.this.element.setAttributeNS(SVGOMAnimatedNumberList.this.namespaceURI, SVGOMAnimatedNumberList.this.localName, string);
            }
            finally {
                SVGOMAnimatedNumberList.this.changing = false;
            }
        }

        protected void revalidate() {
            boolean bl;
            if (this.valid) {
                return;
            }
            String string = this.getValueAsString();
            boolean bl2 = bl = string != null && string.length() == 0;
            if (string == null || bl && !SVGOMAnimatedNumberList.this.emptyAllowed) {
                throw new LiveAttributeException(SVGOMAnimatedNumberList.this.element, SVGOMAnimatedNumberList.this.localName, 0, null);
            }
            if (bl) {
                this.itemList = new ArrayList(1);
            } else {
                try {
                    AbstractSVGList.ListBuilder listBuilder = new AbstractSVGList.ListBuilder(this);
                    this.doParse(string, listBuilder);
                    if (listBuilder.getList() != null) {
                        this.clear(this.itemList);
                    }
                    this.itemList = listBuilder.getList();
                }
                catch (ParseException parseException) {
                    this.itemList = new ArrayList(1);
                    this.valid = true;
                    throw new LiveAttributeException(SVGOMAnimatedNumberList.this.element, SVGOMAnimatedNumberList.this.localName, 1, string);
                }
            }
            this.valid = true;
        }
    }
}

