/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.anim.values.AnimatableTransformListValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.AbstractSVGTransform;
import org.apache.batik.dom.svg.AbstractSVGTransformList;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public class SVGOMAnimatedTransformList
extends AbstractSVGAnimatedValue
implements SVGAnimatedTransformList {
    protected BaseSVGTransformList baseVal;
    protected AnimSVGTransformList animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedTransformList(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    public SVGTransformList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGTransformList();
        }
        return this.baseVal;
    }

    public SVGTransformList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGTransformList();
        }
        return this.animVal;
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGTransformList sVGTransformList = this.getBaseVal();
        int n = sVGTransformList.getNumberOfItems();
        ArrayList<AbstractSVGTransform> arrayList = new ArrayList<AbstractSVGTransform>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((AbstractSVGTransform)sVGTransformList.getItem(i));
        }
        return new AnimatableTransformListValue(animationTarget, arrayList);
    }

    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableTransformListValue animatableTransformListValue = (AnimatableTransformListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGTransformList();
            }
            this.animVal.setAnimatedValue(animatableTransformListValue.getTransforms());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGTransformList
    extends AbstractSVGTransformList {
        public AnimSVGTransformList() {
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(s, string, objectArray);
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedTransformList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedTransformList.this.getBaseVal().getNumberOfItems();
        }

        public SVGTransform getItem(int n) throws DOMException {
            if (SVGOMAnimatedTransformList.this.hasAnimVal) {
                return super.getItem(n);
            }
            return SVGOMAnimatedTransformList.this.getBaseVal().getItem(n);
        }

        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuffer.toString();
        }

        protected void setAttributeValue(String string) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform initialize(SVGTransform sVGTransform) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform insertItemBefore(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform replaceItem(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform removeItem(int n) throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform appendItem(SVGTransform sVGTransform) throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform consolidate() {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        protected void setAnimatedValue(Iterator iterator) {
            int n;
            int n2 = this.itemList.size();
            for (n = 0; n < n2 && iterator.hasNext(); ++n) {
                AbstractSVGTransformList.SVGTransformItem sVGTransformItem = (AbstractSVGTransformList.SVGTransformItem)this.itemList.get(n);
                sVGTransformItem.assign((SVGTransform)iterator.next());
            }
            while (iterator.hasNext()) {
                this.appendItemImpl(new AbstractSVGTransformList.SVGTransformItem((SVGTransform)iterator.next()));
                ++n;
            }
            while (n2 > n) {
                this.removeItemImpl(--n2);
            }
        }

        protected void setAnimatedValue(SVGTransform sVGTransform) {
            int n = this.itemList.size();
            while (n > 1) {
                this.removeItemImpl(--n);
            }
            if (n == 0) {
                this.appendItemImpl(new AbstractSVGTransformList.SVGTransformItem(sVGTransform));
            } else {
                AbstractSVGTransformList.SVGTransformItem sVGTransformItem = (AbstractSVGTransformList.SVGTransformItem)this.itemList.get(0);
                sVGTransformItem.assign(sVGTransform);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem sVGItem) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGTransformList
    extends AbstractSVGTransformList {
        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(s, string, objectArray);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedTransformList.this.element.getAttributeNodeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedTransformList.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedTransformList.this.changing = true;
                SVGOMAnimatedTransformList.this.element.setAttributeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName, string);
            }
            finally {
                SVGOMAnimatedTransformList.this.changing = false;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            String string = this.getValueAsString();
            if (string == null) {
                throw new LiveAttributeException(SVGOMAnimatedTransformList.this.element, SVGOMAnimatedTransformList.this.localName, 0, null);
            }
            try {
                AbstractSVGList.ListBuilder listBuilder = new AbstractSVGList.ListBuilder();
                this.doParse(string, listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.valid = true;
                throw new LiveAttributeException(SVGOMAnimatedTransformList.this.element, SVGOMAnimatedTransformList.this.localName, 1, string);
            }
            this.valid = true;
        }
    }
}

