/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.css.dom.CSSOMSVGColor;
import org.apache.batik.css.dom.CSSOMSVGPaint;
import org.apache.batik.css.dom.CSSOMStoredStyleDeclaration;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleDeclarationProvider;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.css.engine.value.svg.SVGPaintManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.anim.AnimationTargetListener;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGAnimationTargetContext;
import org.apache.batik.dom.svg.SVGOMAnimatedString;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.TraitInformation;
import org.apache.batik.dom.util.DoublyIndexedTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.svg.SVGAnimatedString;

public abstract class SVGStylableElement
extends SVGOMElement
implements CSSStylableElement {
    protected static DoublyIndexedTable xmlTraitInformation;
    protected StyleMap computedStyleMap;
    protected OverrideStyleDeclaration overrideStyleDeclaration;
    protected SVGOMAnimatedString className;
    protected StyleDeclaration style;

    protected SVGStylableElement() {
    }

    protected SVGStylableElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.className = this.createLiveAnimatedString(null, "class");
    }

    public CSSStyleDeclaration getOverrideStyle() {
        if (this.overrideStyleDeclaration == null) {
            CSSEngine cSSEngine = ((SVGOMDocument)this.getOwnerDocument()).getCSSEngine();
            this.overrideStyleDeclaration = new OverrideStyleDeclaration(cSSEngine);
        }
        return this.overrideStyleDeclaration;
    }

    public StyleMap getComputedStyleMap(String string) {
        return this.computedStyleMap;
    }

    public void setComputedStyleMap(String string, StyleMap styleMap) {
        this.computedStyleMap = styleMap;
    }

    public String getXMLId() {
        return this.getAttributeNS(null, "id");
    }

    public String getCSSClass() {
        return this.getAttributeNS(null, "class");
    }

    public URL getCSSBase() {
        if (this.getXblBoundElement() != null) {
            return null;
        }
        String string = this.getBaseURI();
        if (string == null) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = "MalformedURLException:" + malformedURLException.getMessage() + ':' + string;
            throw new IllegalArgumentException(string2);
        }
    }

    public boolean isPseudoInstanceOf(String string) {
        if (string.equals("first-child")) {
            Node node;
            for (node = this.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
            }
            return node == null;
        }
        return false;
    }

    public StyleDeclarationProvider getOverrideStyleDeclarationProvider() {
        return (StyleDeclarationProvider)((Object)this.getOverrideStyle());
    }

    public void updatePropertyValue(String string, AnimatableValue animatableValue) {
        CSSStyleDeclaration cSSStyleDeclaration = this.getOverrideStyle();
        if (animatableValue == null) {
            cSSStyleDeclaration.removeProperty(string);
        } else {
            cSSStyleDeclaration.setProperty(string, animatableValue.getCssText(), "");
        }
    }

    public boolean useLinearRGBColorInterpolation() {
        CSSEngine cSSEngine = ((SVGOMDocument)this.getOwnerDocument()).getCSSEngine();
        Value value = cSSEngine.getComputedStyle(this, null, 6);
        return value.getStringValue().charAt(0) == 'l';
    }

    public void addTargetListener(String string, String string2, boolean bl, AnimationTargetListener animationTargetListener) {
        if (bl && this.svgContext != null) {
            ((SVGAnimationTargetContext)this.svgContext).addTargetListener(string2, animationTargetListener);
        } else {
            super.addTargetListener(string, string2, bl, animationTargetListener);
        }
    }

    public void removeTargetListener(String string, String string2, boolean bl, AnimationTargetListener animationTargetListener) {
        if (bl) {
            ((SVGAnimationTargetContext)this.svgContext).removeTargetListener(string2, animationTargetListener);
        } else {
            super.removeTargetListener(string, string2, bl, animationTargetListener);
        }
    }

    public CSSStyleDeclaration getStyle() {
        if (this.style == null) {
            CSSEngine cSSEngine = ((SVGOMDocument)this.getOwnerDocument()).getCSSEngine();
            this.style = new StyleDeclaration(cSSEngine);
            this.putLiveAttributeValue(null, "style", this.style);
        }
        return this.style;
    }

    public CSSValue getPresentationAttribute(String string) {
        CSSValue cSSValue = (CSSValue)((Object)this.getLiveAttributeValue(null, string));
        if (cSSValue != null) {
            return cSSValue;
        }
        CSSEngine cSSEngine = ((SVGOMDocument)this.getOwnerDocument()).getCSSEngine();
        int n = cSSEngine.getPropertyIndex(string);
        if (n == -1) {
            return null;
        }
        if (n > 59) {
            if (cSSEngine.getValueManagers()[n] instanceof SVGPaintManager) {
                cSSValue = new PresentationAttributePaintValue(cSSEngine, string);
            }
            if (cSSEngine.getValueManagers()[n] instanceof SVGColorManager) {
                cSSValue = new PresentationAttributeColorValue(cSSEngine, string);
            }
        } else {
            switch (n) {
                case 15: 
                case 45: {
                    cSSValue = new PresentationAttributePaintValue(cSSEngine, string);
                    break;
                }
                case 19: 
                case 33: 
                case 43: {
                    cSSValue = new PresentationAttributeColorValue(cSSEngine, string);
                    break;
                }
                default: {
                    cSSValue = new PresentationAttributeValue(cSSEngine, string);
                }
            }
        }
        this.putLiveAttributeValue(null, string, (LiveAttributeValue)((Object)cSSValue));
        return cSSValue;
    }

    public SVGAnimatedString getClassName() {
        return this.className;
    }

    protected DoublyIndexedTable getTraitInformationTable() {
        return xmlTraitInformation;
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable(SVGOMElement.xmlTraitInformation);
        doublyIndexedTable.put(null, "class", new TraitInformation(true, 16));
        xmlTraitInformation = doublyIndexedTable;
    }

    protected class OverrideStyleDeclaration
    extends CSSOMStoredStyleDeclaration {
        protected OverrideStyleDeclaration(CSSEngine cSSEngine) {
            super(cSSEngine);
            this.declaration = new org.apache.batik.css.engine.StyleDeclaration();
        }

        public void textChanged(String string) throws DOMException {
            ((SVGOMDocument)SVGStylableElement.this.ownerDocument).overrideStyleTextChanged(SVGStylableElement.this, string);
        }

        public void propertyRemoved(String string) throws DOMException {
            ((SVGOMDocument)SVGStylableElement.this.ownerDocument).overrideStylePropertyRemoved(SVGStylableElement.this, string);
        }

        public void propertyChanged(String string, String string2, String string3) throws DOMException {
            ((SVGOMDocument)SVGStylableElement.this.ownerDocument).overrideStylePropertyChanged(SVGStylableElement.this, string, string2, string3);
        }
    }

    public class StyleDeclaration
    extends CSSOMStoredStyleDeclaration
    implements LiveAttributeValue,
    CSSEngine.MainPropertyReceiver {
        protected boolean mutate;

        public StyleDeclaration(CSSEngine cSSEngine) {
            super(cSSEngine);
            this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, SVGStylableElement.this.getAttributeNS(null, "style"));
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.declaration = new org.apache.batik.css.engine.StyleDeclaration();
            }
        }

        public void textChanged(String string) throws DOMException {
            this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, string);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", string);
            this.mutate = false;
        }

        public void propertyRemoved(String string) throws DOMException {
            int n = this.cssEngine.getPropertyIndex(string);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (n != this.declaration.getIndex(i)) continue;
                this.declaration.remove(i);
                this.mutate = true;
                SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
                this.mutate = false;
                return;
            }
        }

        public void propertyChanged(String string, String string2, String string3) throws DOMException {
            boolean bl = string3 != null && string3.length() > 0;
            this.cssEngine.setMainProperties(SVGStylableElement.this, this, string, string2, bl);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
            this.mutate = false;
        }

        public void setMainProperty(String string, Value value, boolean bl) {
            int n;
            int n2 = this.cssEngine.getPropertyIndex(string);
            if (n2 == -1) {
                return;
            }
            for (n = 0; n < this.declaration.size() && n2 != this.declaration.getIndex(n); ++n) {
            }
            if (n < this.declaration.size()) {
                this.declaration.put(n, value, n2, bl);
            } else {
                this.declaration.append(value, n2, bl);
            }
        }
    }

    public class PresentationAttributePaintValue
    extends CSSOMSVGPaint
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributePaintValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMSVGPaint.AbstractModificationHandler(this, SVGStylableElement.this){
                private final /* synthetic */ SVGStylableElement val$this$0;
                private final /* synthetic */ PresentationAttributePaintValue this$1;
                {
                    this.this$1 = presentationAttributePaintValue;
                    this.val$this$0 = sVGStylableElement;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue(PresentationAttributePaintValue.access$200(this.this$1), this.this$1.property, string);
                    this.this$1.mutate = true;
                    PresentationAttributePaintValue.access$200(this.this$1).setAttributeNS(null, this.this$1.property, string);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$200(PresentationAttributePaintValue presentationAttributePaintValue) {
            return presentationAttributePaintValue.SVGStylableElement.this;
        }
    }

    public class PresentationAttributeColorValue
    extends CSSOMSVGColor
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeColorValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMSVGColor.AbstractModificationHandler(this, SVGStylableElement.this){
                private final /* synthetic */ SVGStylableElement val$this$0;
                private final /* synthetic */ PresentationAttributeColorValue this$1;
                {
                    this.this$1 = presentationAttributeColorValue;
                    this.val$this$0 = sVGStylableElement;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue(PresentationAttributeColorValue.access$100(this.this$1), this.this$1.property, string);
                    this.this$1.mutate = true;
                    PresentationAttributeColorValue.access$100(this.this$1).setAttributeNS(null, this.this$1.property, string);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$100(PresentationAttributeColorValue presentationAttributeColorValue) {
            return presentationAttributeColorValue.SVGStylableElement.this;
        }
    }

    public class PresentationAttributeValue
    extends CSSOMValue
    implements LiveAttributeValue,
    CSSOMValue.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMValue.AbstractModificationHandler(this, SVGStylableElement.this){
                private final /* synthetic */ SVGStylableElement val$this$0;
                private final /* synthetic */ PresentationAttributeValue this$1;
                {
                    this.this$1 = presentationAttributeValue;
                    this.val$this$0 = sVGStylableElement;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue(PresentationAttributeValue.access$000(this.this$1), this.this$1.property, string);
                    this.this$1.mutate = true;
                    PresentationAttributeValue.access$000(this.this$1).setAttributeNS(null, this.this$1.property, string);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$000(PresentationAttributeValue presentationAttributeValue) {
            return presentationAttributeValue.SVGStylableElement.this;
        }
    }
}

