/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener;

public abstract class AbstractAWTEventDispatcher
implements EventDispatcher,
MouseListener,
MouseMotionListener,
KeyListener {
    protected GraphicsNode root;
    protected AffineTransform baseTransform;
    protected EventListenerList glisteners;
    protected GraphicsNode lastHit;
    protected GraphicsNode currentKeyEventTarget;
    protected List eventQueue = new LinkedList();
    protected boolean eventDispatchEnabled = true;
    protected int eventQueueMaxSize = 10;
    static final int MAX_QUEUE_SIZE = 10;
    private int nodeIncrementEventID = 401;
    private int nodeIncrementEventCode = 9;
    private int nodeIncrementEventModifiers = 0;
    private int nodeDecrementEventID = 401;
    private int nodeDecrementEventCode = 9;
    private int nodeDecrementEventModifiers = 1;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeKeyListener;

    public void setRootNode(GraphicsNode graphicsNode) {
        if (this.root != graphicsNode) {
            this.eventQueue.clear();
        }
        this.root = graphicsNode;
    }

    public GraphicsNode getRootNode() {
        return this.root;
    }

    public void setBaseTransform(AffineTransform affineTransform) {
        if (!(this.baseTransform == affineTransform || this.baseTransform != null && this.baseTransform.equals(affineTransform))) {
            this.eventQueue.clear();
        }
        this.baseTransform = affineTransform;
    }

    public AffineTransform getBaseTransform() {
        return new AffineTransform(this.baseTransform);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, graphicsNodeMouseListener);
    }

    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, graphicsNodeMouseListener);
        }
    }

    public void addGraphicsNodeMouseWheelListener(GraphicsNodeMouseWheelListener graphicsNodeMouseWheelListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener, graphicsNodeMouseWheelListener);
    }

    public void removeGraphicsNodeMouseWheelListener(GraphicsNodeMouseWheelListener graphicsNodeMouseWheelListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener, graphicsNodeMouseWheelListener);
        }
    }

    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, graphicsNodeKeyListener);
    }

    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, graphicsNodeKeyListener);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        Object object = Array.newInstance(clazz, this.glisteners.getListenerCount(clazz));
        Object[] objectArray = this.glisteners.getListenerList();
        int n = 0;
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            if (!objectArray[i].equals(clazz)) continue;
            Array.set(object, n, objectArray[i + 1]);
            ++n;
        }
        return (EventListener[])object;
    }

    public void setEventDispatchEnabled(boolean bl) {
        this.eventDispatchEnabled = bl;
        if (this.eventDispatchEnabled) {
            while (this.eventQueue.size() > 0) {
                EventObject eventObject = (EventObject)this.eventQueue.remove(0);
                this.dispatchEvent(eventObject);
            }
        }
    }

    public void setEventQueueMaxSize(int n) {
        this.eventQueueMaxSize = n;
        if (n == 0) {
            this.eventQueue.clear();
        }
        while (this.eventQueue.size() > this.eventQueueMaxSize) {
            this.eventQueue.remove(0);
        }
    }

    public void dispatchEvent(EventObject eventObject) {
        if (this.root == null) {
            return;
        }
        if (!this.eventDispatchEnabled) {
            if (this.eventQueueMaxSize > 0) {
                this.eventQueue.add(eventObject);
                while (this.eventQueue.size() > this.eventQueueMaxSize) {
                    this.eventQueue.remove(0);
                }
            }
            return;
        }
        if (eventObject instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)eventObject);
        } else if (eventObject instanceof KeyEvent) {
            InputEvent inputEvent = (InputEvent)eventObject;
            if (this.isNodeIncrementEvent(inputEvent)) {
                this.incrementKeyTarget();
            } else if (this.isNodeDecrementEvent(inputEvent)) {
                this.decrementKeyTarget();
            } else {
                this.dispatchKeyEvent((KeyEvent)eventObject);
            }
        }
    }

    protected int getCurrentLockState() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = 0;
        try {
            if (toolkit.getLockingKeyState(262)) {
                ++n;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        n <<= 1;
        try {
            if (toolkit.getLockingKeyState(145)) {
                ++n;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        n <<= 1;
        try {
            if (toolkit.getLockingKeyState(144)) {
                ++n;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        n <<= 1;
        try {
            if (toolkit.getLockingKeyState(20)) {
                ++n;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return n;
    }

    protected abstract void dispatchKeyEvent(KeyEvent var1);

    protected abstract int getModifiers(InputEvent var1);

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        GraphicsNodeMouseEvent graphicsNodeMouseEvent;
        Point point;
        Point2D.Float float_ = new Point2D.Float(mouseEvent.getX(), mouseEvent.getY());
        Point2D point2D = float_;
        if (this.baseTransform != null) {
            point2D = this.baseTransform.transform(float_, null);
        }
        GraphicsNode graphicsNode = this.root.nodeHitAt(point2D);
        if (!mouseEvent.getComponent().isShowing()) {
            point = new Point(0, 0);
        } else {
            point = mouseEvent.getComponent().getLocationOnScreen();
            point.x += mouseEvent.getX();
            point.y += mouseEvent.getY();
        }
        int n = this.getCurrentLockState();
        if (this.lastHit != graphicsNode) {
            if (this.lastHit != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.lastHit, 505, mouseEvent.getWhen(), this.getModifiers(mouseEvent), n, (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), graphicsNode);
                this.processMouseEvent(graphicsNodeMouseEvent);
            }
            if (graphicsNode != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, 504, mouseEvent.getWhen(), this.getModifiers(mouseEvent), n, (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), this.lastHit);
                this.processMouseEvent(graphicsNodeMouseEvent);
            }
        }
        if (graphicsNode != null) {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, mouseEvent.getID(), mouseEvent.getWhen(), this.getModifiers(mouseEvent), n, (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), null);
            this.processMouseEvent(graphicsNodeMouseEvent);
        } else {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.root, mouseEvent.getID(), mouseEvent.getWhen(), this.getModifiers(mouseEvent), n, (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), null);
            this.processMouseEvent(graphicsNodeMouseEvent);
        }
        this.lastHit = graphicsNode;
    }

    protected void processMouseEvent(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        if (this.glisteners != null) {
            GraphicsNodeMouseListener[] graphicsNodeMouseListenerArray = (GraphicsNodeMouseListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener);
            switch (graphicsNodeMouseEvent.getID()) {
                case 503: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseMoved(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 506: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseDragged(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 504: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseEntered(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 505: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseExited(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 500: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseClicked(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 501: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mousePressed(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 502: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseReleased(graphicsNodeMouseEvent);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Mouse Event type: " + graphicsNodeMouseEvent.getID());
                }
            }
        }
    }

    public void processKeyEvent(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        if (this.glisteners != null) {
            GraphicsNodeKeyListener[] graphicsNodeKeyListenerArray = (GraphicsNodeKeyListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener);
            switch (graphicsNodeKeyEvent.getID()) {
                case 401: {
                    for (int i = 0; i < graphicsNodeKeyListenerArray.length; ++i) {
                        graphicsNodeKeyListenerArray[i].keyPressed(graphicsNodeKeyEvent);
                    }
                    break;
                }
                case 402: {
                    for (int i = 0; i < graphicsNodeKeyListenerArray.length; ++i) {
                        graphicsNodeKeyListenerArray[i].keyReleased(graphicsNodeKeyEvent);
                    }
                    break;
                }
                case 400: {
                    for (int i = 0; i < graphicsNodeKeyListenerArray.length; ++i) {
                        graphicsNodeKeyListenerArray[i].keyTyped(graphicsNodeKeyEvent);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Key Event type: " + graphicsNodeKeyEvent.getID());
                }
            }
        }
        graphicsNodeKeyEvent.consume();
    }

    private void incrementKeyTarget() {
        throw new UnsupportedOperationException("Increment not implemented.");
    }

    private void decrementKeyTarget() {
        throw new UnsupportedOperationException("Decrement not implemented.");
    }

    public void setNodeIncrementEvent(InputEvent inputEvent) {
        this.nodeIncrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeIncrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeIncrementEventModifiers = inputEvent.getModifiers();
    }

    public void setNodeDecrementEvent(InputEvent inputEvent) {
        this.nodeDecrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeDecrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeDecrementEventModifiers = inputEvent.getModifiers();
    }

    protected boolean isNodeIncrementEvent(InputEvent inputEvent) {
        if (inputEvent.getID() != this.nodeIncrementEventID) {
            return false;
        }
        if (inputEvent instanceof KeyEvent && ((KeyEvent)inputEvent).getKeyCode() != this.nodeIncrementEventCode) {
            return false;
        }
        return (inputEvent.getModifiers() & this.nodeIncrementEventModifiers) != 0;
    }

    protected boolean isNodeDecrementEvent(InputEvent inputEvent) {
        if (inputEvent.getID() != this.nodeDecrementEventID) {
            return false;
        }
        if (inputEvent instanceof KeyEvent && ((KeyEvent)inputEvent).getKeyCode() != this.nodeDecrementEventCode) {
            return false;
        }
        return (inputEvent.getModifiers() & this.nodeDecrementEventModifiers) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

