/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.fonts.type1.PFMFile;
import org.apache.fop.util.CommandLineLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PFMReader {
    protected static Log log;
    static /* synthetic */ Class class$org$apache$fop$fonts$apps$PFMReader;
    static /* synthetic */ Class class$org$apache$fop$util$CommandLineLogger;

    public PFMReader() {
        if (log == null) {
            log = LogFactory.getLog(class$org$apache$fop$fonts$apps$PFMReader == null ? (class$org$apache$fop$fonts$apps$PFMReader = PFMReader.class$("org.apache.fop.fonts.apps.PFMReader")) : class$org$apache$fop$fonts$apps$PFMReader);
        }
    }

    private static String[] parseArguments(Map options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if ("-d".equals(args[i]) || "-q".equals(args[i])) {
                    options.put(args[i], "");
                } else if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                } else {
                    options.put(args[i], "");
                }
            } else {
                arguments.add(args[i]);
            }
            ++i;
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private static void displayUsage() {
        System.out.println("java " + (class$org$apache$fop$fonts$apps$PFMReader == null ? (class$org$apache$fop$fonts$apps$PFMReader = PFMReader.class$("org.apache.fop.fonts.apps.PFMReader")) : class$org$apache$fop$fonts$apps$PFMReader).getName() + " [options] metricfile.pfm xmlfile.xml");
        System.out.println();
        System.out.println("where options can be:");
        System.out.println("-d  Debug mode");
        System.out.println("-q  Quiet mode");
        System.out.println("-fn <fontname>");
        System.out.println("    default is to use the fontname in the .pfm file, but");
        System.out.println("    you can override that name to make sure that the");
        System.out.println("    embedded font is used (if you're embedding fonts)");
        System.out.println("    instead of installed fonts when viewing documents ");
        System.out.println("    with Acrobat Reader.");
    }

    public static void main(String[] args) {
        String embFile = null;
        String embResource = null;
        String className = null;
        String fontName = null;
        HashMap options = new HashMap();
        String[] arguments = PFMReader.parseArguments(options, args);
        LogFactory logFactory = LogFactory.getFactory();
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            logFactory.setAttribute("org.apache.commons.logging.Log", (class$org$apache$fop$util$CommandLineLogger == null ? (class$org$apache$fop$util$CommandLineLogger = PFMReader.class$("org.apache.fop.util.CommandLineLogger")) : class$org$apache$fop$util$CommandLineLogger).getName());
        }
        if (options.get("-d") != null) {
            PFMReader.setLogLevel("debug");
        } else if (options.get("-q") != null) {
            PFMReader.setLogLevel("error");
        } else {
            PFMReader.setLogLevel("info");
        }
        PFMReader app = new PFMReader();
        log.info("PFM Reader for Apache FOP " + Version.getVersion() + "\n");
        if (options.get("-ef") != null) {
            embFile = (String)options.get("-ef");
        }
        if (options.get("-er") != null) {
            embResource = (String)options.get("-er");
        }
        if (options.get("-fn") != null) {
            fontName = (String)options.get("-fn");
        }
        if (options.get("-cn") != null) {
            className = (String)options.get("-cn");
        }
        if (arguments.length != 2 || options.get("-h") != null || options.get("-help") != null || options.get("--help") != null) {
            PFMReader.displayUsage();
        } else {
            try {
                log.info("Parsing font...");
                PFMFile pfm = app.loadPFM(arguments[0]);
                if (pfm != null) {
                    app.preview(pfm);
                    Document doc = app.constructFontXML(pfm, fontName, className, embResource, embFile);
                    app.writeFontXML(doc, arguments[1]);
                }
                log.info("XML font metrics file successfullly created.");
            }
            catch (Exception e) {
                log.error("Error while building XML font metrics file", e);
                System.exit(-1);
            }
        }
    }

    private static void setLogLevel(String level) {
        LogFactory.getFactory().setAttribute("level", level);
        if (log instanceof CommandLineLogger) {
            ((CommandLineLogger)log).setLogLevel(level);
        }
    }

    public PFMFile loadPFM(String filename) throws IOException {
        PFMFile pFMFile;
        log.info("Reading " + filename + "...");
        log.info("");
        FileInputStream in = new FileInputStream(filename);
        try {
            PFMFile pfm = new PFMFile();
            pfm.load(in);
            pFMFile = pfm;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        return pFMFile;
    }

    public void preview(PFMFile pfm) {
        if (log != null & log.isInfoEnabled()) {
            log.info("Font: " + pfm.getWindowsName());
            log.info("Name: " + pfm.getPostscriptName());
            log.info("CharSet: " + pfm.getCharSetName());
            log.info("CapHeight: " + pfm.getCapHeight());
            log.info("XHeight: " + pfm.getXHeight());
            log.info("LowerCaseAscent: " + pfm.getLowerCaseAscent());
            log.info("LowerCaseDescent: " + pfm.getLowerCaseDescent());
            log.info("Having widths for " + (pfm.getLastChar() - pfm.getFirstChar()) + " characters (" + pfm.getFirstChar() + "-" + pfm.getLastChar() + ").");
            log.info("for example: Char " + pfm.getFirstChar() + " has a width of " + pfm.getCharWidth(pfm.getFirstChar()));
            log.info("");
        }
    }

    public void writeFontXML(Document doc, String target) throws TransformerException {
        log.info("Writing xml font file " + target + "...");
        log.info("");
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(new File(target)));
    }

    public Document constructFontXML(PFMFile pfm, String fontName, String className, String resource, String file) {
        Document doc;
        log.info("Creating xml font file...");
        log.info("");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            log.error("Can't create DOM implementation", e);
            return null;
        }
        Element root = doc.createElement("font-metrics");
        doc.appendChild(root);
        root.setAttribute("type", "TYPE1");
        Element el = doc.createElement("font-name");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(pfm.getPostscriptName()));
        String s = pfm.getPostscriptName();
        int pos = s.indexOf("-");
        if (pos >= 0) {
            char[] sb = new char[s.length() - 1];
            s.getChars(0, pos, sb, 0);
            s.getChars(pos + 1, s.length(), sb, pos);
            s = new String(sb);
        }
        el = doc.createElement("embed");
        root.appendChild(el);
        if (file != null) {
            el.setAttribute("file", file);
        }
        if (resource != null) {
            el.setAttribute("class", resource);
        }
        el = doc.createElement("encoding");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(pfm.getCharSetName() + "Encoding"));
        el = doc.createElement("cap-height");
        root.appendChild(el);
        Integer value = new Integer(pfm.getCapHeight());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("x-height");
        root.appendChild(el);
        value = new Integer(pfm.getXHeight());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("ascender");
        root.appendChild(el);
        value = new Integer(pfm.getLowerCaseAscent());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("descender");
        root.appendChild(el);
        value = new Integer(-pfm.getLowerCaseDescent());
        el.appendChild(doc.createTextNode(value.toString()));
        Element bbox = doc.createElement("bbox");
        root.appendChild(bbox);
        int[] bb = pfm.getFontBBox();
        String[] names = new String[]{"left", "bottom", "right", "top"};
        int i = 0;
        while (i < names.length) {
            el = doc.createElement(names[i]);
            bbox.appendChild(el);
            value = new Integer(bb[i]);
            el.appendChild(doc.createTextNode(value.toString()));
            ++i;
        }
        el = doc.createElement("flags");
        root.appendChild(el);
        value = new Integer(pfm.getFlags());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("stemv");
        root.appendChild(el);
        value = new Integer(pfm.getStemV());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("italicangle");
        root.appendChild(el);
        value = new Integer(pfm.getItalicAngle());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("first-char");
        root.appendChild(el);
        value = new Integer(pfm.getFirstChar());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("last-char");
        root.appendChild(el);
        value = new Integer(pfm.getLastChar());
        el.appendChild(doc.createTextNode(value.toString()));
        Element widths = doc.createElement("widths");
        root.appendChild(widths);
        short i2 = pfm.getFirstChar();
        while (i2 <= pfm.getLastChar()) {
            el = doc.createElement("char");
            widths.appendChild(el);
            el.setAttribute("idx", Integer.toString(i2));
            el.setAttribute("wdt", new Integer(pfm.getCharWidth(i2)).toString());
            i2 = (short)(i2 + 1);
        }
        Iterator iter = pfm.getKerning().keySet().iterator();
        while (iter.hasNext()) {
            Integer kpx1 = (Integer)iter.next();
            el = doc.createElement("kerning");
            el.setAttribute("kpx1", kpx1.toString());
            root.appendChild(el);
            Element el2 = null;
            Map h2 = (Map)pfm.getKerning().get(kpx1);
            Iterator enum2 = h2.keySet().iterator();
            while (enum2.hasNext()) {
                Integer kpx2 = (Integer)enum2.next();
                el2 = doc.createElement("pair");
                el2.setAttribute("kpx2", kpx2.toString());
                Integer val = (Integer)h2.get(kpx2);
                el2.setAttribute("kern", val.toString());
                el.appendChild(el2);
            }
        }
        return doc;
    }

    private String escapeString(String str) {
        StringBuffer esc = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                esc.append("\\\\");
            } else {
                esc.append(str.charAt(i));
            }
            ++i;
        }
        return esc.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

