/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.parser.UnitProcessor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.XMLImage;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGReader
implements ImageReader {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$image$analyser$SVGReader == null ? (class$org$apache$fop$image$analyser$SVGReader = SVGReader.class$("org.apache.fop.image.analyser.SVGReader")) : class$org$apache$fop$image$analyser$SVGReader);
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    private boolean batik = true;
    static /* synthetic */ Class class$org$apache$fop$image$analyser$SVGReader;

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        FopImage.ImageInfo info = this.loadImage(uri, fis, ua);
        if (info != null) {
            IOUtils.closeQuietly(fis);
        }
        return info;
    }

    public String getMimeType() {
        return SVG_MIME_TYPE;
    }

    private FopImage.ImageInfo loadImage(String uri, InputStream bis, FOUserAgent ua) {
        if (this.batik) {
            try {
                Loader loader = new Loader();
                return loader.getImage(uri, bis, ua.getPixelUnitToMillimeter());
            }
            catch (NoClassDefFoundError e) {
                this.batik = false;
                log.warn("Batik not in class path", e);
                return null;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Loader {
        Loader() {
        }

        private FopImage.ImageInfo getImage(String uri, InputStream fis, float pixelUnitToMM) {
            try {
                int length = 5;
                fis.mark(length);
                byte[] b = new byte[length];
                fis.read(b);
                String start = new String(b);
                fis.reset();
                InputStream input = fis;
                fis = new InputStream(this, input){
                    private final /* synthetic */ InputStream val$input;
                    private final /* synthetic */ Loader this$1;
                    {
                        this.this$1 = this$1;
                        this.val$input = val$input;
                    }

                    public int read() throws IOException {
                        return this.val$input.read();
                    }

                    public int read(byte[] b) throws IOException {
                        return this.val$input.read(b);
                    }

                    public int read(byte[] b, int off, int len) throws IOException {
                        return this.val$input.read(b, off, len);
                    }

                    public long skip(long n) throws IOException {
                        return this.val$input.skip(n);
                    }

                    public int available() throws IOException {
                        return this.val$input.available();
                    }

                    public void mark(int rl) {
                        this.val$input.mark(rl);
                    }

                    public boolean markSupported() {
                        return this.val$input.markSupported();
                    }

                    public void reset() throws IOException {
                        this.val$input.reset();
                    }

                    public void close() throws IOException {
                    }
                };
                FopImage.ImageInfo info = new FopImage.ImageInfo();
                info.dpiVertical = info.dpiHorizontal = (double)(25.4f / pixelUnitToMM);
                info.originalURI = uri;
                info.mimeType = SVGReader.this.getMimeType();
                info.str = "http://www.w3.org/2000/svg";
                length = fis.available();
                fis.mark(length + 1);
                SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLImage.getParserName());
                SVGDocument doc = factory.createSVGDocument(uri, fis);
                info.data = doc;
                SVGSVGElement e = doc.getRootElement();
                SVGUserAgent userAg = new SVGUserAgent(pixelUnitToMM, new AffineTransform());
                BridgeContext ctx = new BridgeContext(userAg);
                UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
                String s = e.getAttributeNS(null, "width");
                if (s.length() == 0) {
                    s = "100%";
                }
                info.width = Math.round(UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx));
                s = e.getAttributeNS(null, "height");
                if (s.length() == 0) {
                    s = "100%";
                }
                info.height = Math.round(UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx));
                return info;
            }
            catch (NoClassDefFoundError ncdfe) {
                try {
                    fis.reset();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                SVGReader.this.batik = false;
                log.warn("Batik not in class path", ncdfe);
                return null;
            }
            catch (Exception e) {
                log.debug("Error while trying to load stream as an SVG file: " + e.getMessage());
                try {
                    fis.reset();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return null;
            }
        }
    }
}

