/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.io.IOException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.render.ps.AbstractPSDocumentGraphics2D;
import org.apache.fop.render.ps.PSTextElementBridge;
import org.apache.fop.render.ps.PSTextPainter;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.w3c.dom.Document;

public abstract class AbstractPSTranscoder
extends AbstractFOPTranscoder {
    private Configuration cfg = null;
    protected AbstractPSDocumentGraphics2D graphics = null;

    protected abstract AbstractPSDocumentGraphics2D createDocumentGraphics2D();

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = this.createDocumentGraphics2D();
        try {
            if (this.cfg != null) {
                ContainerUtil.configure(this.graphics, this.cfg);
            }
            ContainerUtil.initialize(this.graphics);
        }
        catch (Exception e) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", e);
        }
        super.transcode(document, uri, output);
        this.getLogger().trace("document size: " + this.width + " x " + this.height);
        UnitProcessor.Context uctx = UnitProcessor.createContext(this.ctx, document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG(this.width, (short)9, (short)2, uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG(this.height, (short)9, (short)2, uctx);
        int h = (int)((double)heightInPt + 0.5);
        this.getLogger().trace("document size: " + w + "pt x " + h + "pt");
        try {
            this.graphics.setupDocument(output.getOutputStream(), w, h);
            this.graphics.setSVGDimension(this.width, this.height);
            if (this.hints.containsKey(ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get(ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.setTransform(this.curTxf);
            this.root.paint(this.graphics);
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }

    protected BridgeContext createBridgeContext() {
        BridgeContext ctx = new BridgeContext(this.userAgent);
        PSTextPainter textPainter = new PSTextPainter(this.graphics.getFontInfo());
        ctx.setTextPainter(textPainter);
        ctx.putBridge(new PSTextElementBridge(textPainter));
        return ctx;
    }
}

