/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSGraphics2DAdapter;
import org.apache.fop.render.ps.PSImageUtils;
import org.apache.fop.render.ps.PSProcSets;
import org.apache.fop.render.ps.PSResource;
import org.apache.fop.render.ps.PSSVGHandler;
import org.apache.fop.render.ps.PSState;
import org.apache.fop.render.ps.extensions.PSSetupCode;
import org.apache.fop.util.CharUtilities;
import org.w3c.dom.Document;

public class PSRenderer
extends AbstractPathOrientedRenderer {
    public static final String MIME_TYPE = "application/postscript";
    private int currentPageNumber = 0;
    private boolean enableComments = true;
    private boolean autoRotateLandscape = false;
    protected PSGenerator gen;
    private boolean ioTrouble = false;
    private boolean inTextMode = false;
    private boolean firstPageSequenceReceived = false;
    private List setupCodeList;
    private Map fontResources;

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        this.autoRotateLandscape = cfg.getChild("auto-rotate-landscape").getValueAsBoolean(false);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        PSSVGHandler xmlHandler = new PSSVGHandler();
        this.userAgent.getXMLHandlerRegistry().addXMLHandler((XMLHandler)xmlHandler);
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new PSGraphics2DAdapter(this);
    }

    protected void writeln(String cmd) {
        try {
            this.gen.writeln(cmd);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            AbstractRenderer.log.error("Error while writing to target file", ioe);
            this.ioTrouble = true;
        }
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            if (comment.startsWith("%")) {
                this.writeln(comment);
            } else {
                this.writeln("%" + comment);
            }
        }
    }

    protected void movetoCurrPosition() {
        this.moveTo(this.currentIPPosition, this.currentBPPosition);
    }

    protected void clip() {
        this.writeln("clip newpath");
    }

    protected void clipRect(float x, float y, float width, float height) {
        try {
            this.gen.defineRect(x, y, width, height);
            this.gen.writeln("clip");
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void moveTo(float x, float y) {
        this.writeln(this.gen.formatDouble(x) + " " + this.gen.formatDouble(y) + " M");
    }

    protected void lineTo(float x, float y) {
        this.writeln(this.gen.formatDouble(x) + " " + this.gen.formatDouble(y) + " lineto");
    }

    protected void closePath() {
        this.writeln("cp");
    }

    protected void fillRect(float x, float y, float width, float height) {
        if (width != 0.0f && height != 0.0f) {
            try {
                this.gen.defineRect(x, y, width, height);
                this.gen.writeln("fill");
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
    }

    protected void updateColor(ColorType col, boolean fill) {
        try {
            this.useColor(col);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void drawImage(String url, Rectangle2D pos) {
        this.endTextObject();
        url = ImageFactory.getURL((String)url);
        ImageFactory fact = ImageFactory.getInstance();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        float x = (float)pos.getX() / 1000.0f;
        x += (float)this.currentIPPosition / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        y += (float)this.currentBPPosition / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        try {
            String mime = fopimage.getMimeType();
            if ("text/xml".equals(mime)) {
                if (!fopimage.load(2)) {
                    return;
                }
                Document doc = ((XMLImage)fopimage).getDocument();
                String ns = ((XMLImage)fopimage).getNameSpace();
                this.renderDocument(doc, ns, pos);
            } else if ("image/svg+xml".equals(mime)) {
                if (!fopimage.load(2)) {
                    return;
                }
                Document doc = ((XMLImage)fopimage).getDocument();
                String ns = ((XMLImage)fopimage).getNameSpace();
                this.renderDocument(doc, ns, pos);
            } else if (fopimage instanceof EPSImage) {
                PSImageUtils.renderEPS((EPSImage)fopimage, x, y, w, h, this.gen);
            } else {
                PSImageUtils.renderBitmapImage(fopimage, x, y, w, h, this.gen);
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.writeln(this.gen.formatDouble(startx) + " " + this.gen.formatDouble(starty) + " M " + this.gen.formatDouble(endx) + " " + this.gen.formatDouble(endy) + " lineto stroke newpath");
    }

    public void saveGraphicsState() {
        this.endTextObject();
        try {
            this.gen.saveGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void restoreGraphicsState() {
        try {
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double a, double b, double c, double d, double e, double f) {
        try {
            this.gen.concatMatrix(a, b, c, d, e, f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double[] matrix) {
        try {
            this.gen.concatMatrix(matrix);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void useFont(String name, int size) {
        try {
            this.gen.useFont(name, (float)size / 1000.0f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    private void useColor(ColorType col) throws IOException {
        this.gen.useRGBColor(this.toColor(col));
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        if (area.hasTrait((Object)Trait.BACKGROUND) || area.hasTrait((Object)Trait.BORDER_BEFORE) || area.hasTrait((Object)Trait.BORDER_AFTER) || area.hasTrait((Object)Trait.BORDER_START) || area.hasTrait((Object)Trait.BORDER_END)) {
            this.comment("%FOPBeginBackgroundAndBorder: " + startx + " " + starty + " " + width + " " + height);
            super.drawBackAndBorders(area, startx, starty, width, height);
            this.comment("%FOPEndBackgroundAndBorder");
        }
    }

    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, ColorType col) {
        try {
            float w = x2 - x1;
            float h = y2 - y1;
            if (w < 0.0f || h < 0.0f) {
                AbstractRenderer.log.error("Negative extent received. Border won't be painted.");
                return;
            }
            switch (style) {
                case 31: {
                    this.useColor(col);
                    if (horz) {
                        float unit = Math.abs(2.0f * h);
                        int rep = (int)(w / unit);
                        if (rep % 2 == 0) {
                            ++rep;
                        }
                        unit = w / (float)rep;
                        this.gen.useDash("[" + unit + "] 0");
                        this.gen.useLineCap(0);
                        this.gen.useLineWidth(h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    float unit = Math.abs(2.0f * w);
                    int rep = (int)(h / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = h / (float)rep;
                    this.gen.useDash("[" + unit + "] 0");
                    this.gen.useLineCap(0);
                    this.gen.useLineWidth(w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
                case 36: {
                    this.useColor(col);
                    this.gen.useLineCap(1);
                    if (horz) {
                        float unit = Math.abs(2.0f * h);
                        int rep = (int)(w / unit);
                        if (rep % 2 == 0) {
                            ++rep;
                        }
                        unit = w / (float)rep;
                        this.gen.useDash("[0 " + unit + "] 0");
                        this.gen.useLineWidth(h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    float unit = Math.abs(2.0f * w);
                    int rep = (int)(h / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = h / (float)rep;
                    this.gen.useDash("[0 " + unit + "] 0");
                    this.gen.useLineWidth(w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
                case 37: {
                    this.useColor(col);
                    this.gen.useDash(null);
                    if (horz) {
                        float h3 = h / 3.0f;
                        this.gen.useLineWidth(h3);
                        float ym1 = y1 + h3 / 2.0f;
                        float ym2 = ym1 + h3 + h3;
                        this.drawLine(x1, ym1, x2, ym1);
                        this.drawLine(x1, ym2, x2, ym2);
                        break;
                    }
                    float w3 = w / 3.0f;
                    this.gen.useLineWidth(w3);
                    float xm1 = x1 + w3 / 2.0f;
                    float xm2 = xm1 + w3 + w3;
                    this.drawLine(xm1, y1, xm1, y2);
                    this.drawLine(xm2, y1, xm2, y2);
                    break;
                }
                case 55: 
                case 119: {
                    float colFactor = style == 55 ? 0.4f : -0.4f;
                    this.gen.useDash(null);
                    Color c = this.toColor(col);
                    if (horz) {
                        Color uppercol = this.lightenColor(c, -colFactor);
                        Color lowercol = this.lightenColor(c, colFactor);
                        float h3 = h / 3.0f;
                        this.gen.useLineWidth(h3);
                        float ym1 = y1 + h3 / 2.0f;
                        this.gen.useRGBColor(uppercol);
                        this.drawLine(x1, ym1, x2, ym1);
                        this.gen.useRGBColor(c);
                        this.drawLine(x1, ym1 + h3, x2, ym1 + h3);
                        this.gen.useRGBColor(lowercol);
                        this.drawLine(x1, ym1 + h3 + h3, x2, ym1 + h3 + h3);
                        break;
                    }
                    Color leftcol = this.lightenColor(c, -colFactor);
                    Color rightcol = this.lightenColor(c, colFactor);
                    float w3 = w / 3.0f;
                    this.gen.useLineWidth(w3);
                    float xm1 = x1 + w3 / 2.0f;
                    this.gen.useRGBColor(leftcol);
                    this.drawLine(xm1, y1, xm1, y2);
                    this.gen.useRGBColor(c);
                    this.drawLine(xm1 + w3, y1, xm1 + w3, y2);
                    this.gen.useRGBColor(rightcol);
                    this.drawLine(xm1 + w3 + w3, y1, xm1 + w3 + w3, y2);
                    break;
                }
                case 67: 
                case 101: {
                    float colFactor = style == 101 ? 0.4f : -0.4f;
                    this.gen.useDash(null);
                    Color c = this.toColor(col);
                    if (horz) {
                        c = this.lightenColor(c, (startOrBefore ? 1.0f : -1.0f) * colFactor);
                        this.gen.useLineWidth(h);
                        float ym1 = y1 + h / 2.0f;
                        this.gen.useRGBColor(c);
                        this.drawLine(x1, ym1, x2, ym1);
                        break;
                    }
                    c = this.lightenColor(c, (startOrBefore ? 1.0f : -1.0f) * colFactor);
                    this.gen.useLineWidth(w);
                    float xm1 = x1 + w / 2.0f;
                    this.gen.useRGBColor(c);
                    this.drawLine(xm1, y1, xm1, y2);
                    break;
                }
                case 57: {
                    break;
                }
                default: {
                    this.useColor(col);
                    this.gen.useDash(null);
                    this.gen.useLineCap(0);
                    if (horz) {
                        this.gen.useLineWidth(h);
                        float ym = y1 + h / 2.0f;
                        this.drawLine(x1, ym, x2, ym);
                        break;
                    }
                    this.gen.useLineWidth(w);
                    float xm = x1 + w / 2.0f;
                    this.drawLine(xm, y1, xm, y2);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        AbstractRenderer.log.debug("rendering areas to PostScript");
        this.gen = new PSGenerator(outputStream){

            public Source resolveURI(String uri) {
                return AbstractRenderer.access$001((PSRenderer)PSRenderer.this).resolveURI(uri);
            }
        };
        this.currentPageNumber = 0;
        this.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", new String[]{this.userAgent.getProducer()});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("LanguageLevel", new Integer(this.gen.getPSLevel()));
        this.gen.writeDSCComment("Pages", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("DocumentSuppliedResources", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
    }

    public void stopRenderer() throws IOException {
        Map fonts = this.fontInfo.getUsedFonts();
        Iterator e = fonts.keySet().iterator();
        while (e.hasNext()) {
            String key = (String)e.next();
            PSResource res = (PSResource)this.fontResources.get(key);
            boolean supplied = this.gen.isResourceSupplied(res);
            if (supplied) continue;
            this.gen.notifyResourceUsage(res, true);
        }
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("Pages", new Integer(this.currentPageNumber));
        this.gen.writeResources(false);
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    public void processOffDocumentItem(OffDocumentItem oDI) {
        ExtensionAttachment attachment;
        AbstractRenderer.log.debug("Handling OffDocumentItem: " + oDI.getName());
        if (oDI instanceof OffDocumentExtensionAttachment && "apache:fop:extensions:postscript".equals((attachment = ((OffDocumentExtensionAttachment)oDI).getAttachment()).getCategory())) {
            PSSetupCode setupCode = (PSSetupCode)attachment;
            if (this.setupCodeList == null) {
                this.setupCodeList = new ArrayList();
            }
            this.setupCodeList.add(setupCode);
        }
        super.processOffDocumentItem(oDI);
    }

    public void startPageSequence(LineArea seqTitle) {
        super.startPageSequence(seqTitle);
        if (!this.firstPageSequenceReceived) {
            try {
                this.gen.writeDSCComment("BeginProlog");
                PSProcSets.writeFOPStdProcSet(this.gen);
                PSProcSets.writeFOPEPSProcSet(this.gen);
                this.gen.writeDSCComment("EndProlog");
                this.gen.writeDSCComment("BeginSetup");
                this.writeSetupCodeList(this.setupCodeList, "SetupCode");
                this.fontResources = PSFontUtils.writeFontDict(this.gen, this.fontInfo);
                this.gen.writeln("FOPFonts begin");
                this.gen.writeDSCComment("EndSetup");
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
            this.firstPageSequenceReceived = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSetupCodeList(List setupCodeList, String type) throws IOException {
        if (setupCodeList != null) {
            Iterator i = setupCodeList.iterator();
            while (i.hasNext()) {
                String line;
                PSSetupCode setupCode = (PSSetupCode)i.next();
                this.gen.commentln("%FOPBegin" + type + ": (" + (setupCode.getName() != null ? setupCode.getName() : "") + ")");
                LineNumberReader reader = new LineNumberReader(new StringReader(setupCode.getContent()));
                while ((line = reader.readLine()) != null) {
                    void var6_6;
                    line = var6_6.trim();
                    if (line.length() <= 0) continue;
                    this.gen.writeln(line.trim());
                }
                this.gen.commentln("%FOPEnd" + type);
                i.remove();
            }
        }
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        AbstractRenderer.log.debug("renderPage(): " + page);
        ++this.currentPageNumber;
        this.gen.notifyStartNewPage();
        this.gen.notifyResourceUsage(PSProcSets.STD_PROCSET, false);
        this.gen.writeDSCComment("Page", new Object[]{page.getPageNumberString(), new Integer(this.currentPageNumber)});
        Integer zero = new Integer(0);
        long pagewidth = Math.round(page.getViewArea().getWidth());
        long pageheight = Math.round(page.getViewArea().getHeight());
        double pspagewidth = (float)pagewidth / 1000.0f;
        double pspageheight = (float)pageheight / 1000.0f;
        boolean rotate = false;
        if (this.autoRotateLandscape && pageheight < pagewidth) {
            rotate = true;
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspageheight)), new Long(Math.round(pspagewidth))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspageheight), new Double(pspagewidth)});
            this.gen.writeDSCComment("PageOrientation", "Landscape");
        } else {
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspagewidth)), new Long(Math.round(pspageheight))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspagewidth), new Double(pspageheight)});
            if (this.autoRotateLandscape) {
                this.gen.writeDSCComment("PageOrientation", "Portrait");
            }
        }
        this.gen.writeDSCComment("PageResources", new Object[]{PSGenerator.ATEND});
        this.gen.commentln("%FOPSimplePageMaster: " + page.getSPM().getMasterName());
        this.gen.writeDSCComment("BeginPageSetup");
        if (page.getSPM().getExtensionAttachments().size() > 0) {
            ArrayList<ExtensionAttachment> list = new ArrayList<ExtensionAttachment>();
            Iterator i = page.getSPM().getExtensionAttachments().iterator();
            while (i.hasNext()) {
                ExtensionAttachment attachment = (ExtensionAttachment)i.next();
                if (!"apache:fop:extensions:postscript".equals(attachment.getCategory())) continue;
                list.add(attachment);
            }
            this.writeSetupCodeList(list, "PageSetupCode");
        }
        if (rotate) {
            this.gen.writeln(Math.round(pspageheight) + " 0 translate");
            this.gen.writeln("90 rotate");
        }
        this.gen.writeln("<<");
        this.gen.writeln("/PageSize [" + Math.round(pspagewidth) + " " + Math.round(pspageheight) + "]");
        this.gen.writeln("/ImagingBBox null");
        this.gen.writeln(">> setpagedevice");
        this.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, (float)pageheight / 1000.0f);
        this.gen.writeDSCComment("EndPageSetup");
        super.renderPage(page);
        this.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeResources(true);
        this.gen.writeDSCComment("EndPage");
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            this.comment("%FOPBeginRegionViewport: " + port.getRegionReference().getRegionName());
            super.renderRegionViewport(port);
            this.comment("%FOPEndRegionViewport");
        }
    }

    protected void beginTextObject() {
        if (!this.inTextMode) {
            this.saveGraphicsState();
            this.writeln("BT");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() {
        if (this.inTextMode) {
            this.writeln("ET");
            this.restoreGraphicsState();
            this.inTextMode = false;
        }
    }

    public void renderCharacter(Character ch) {
        String text = ch.getChar();
        this.renderText((AbstractTextArea)ch, text);
        super.renderCharacter(ch);
    }

    public void renderText(TextArea area) {
        String text = area.getText();
        this.renderText((AbstractTextArea)area, text);
        super.renderText(area);
    }

    private void renderText(AbstractTextArea area, String text) {
        this.renderInlineAreaBackAndBorders((InlineArea)area);
        String fontname = (String)area.getTrait((Object)Trait.FONT_NAME);
        int fontsize = area.getTraitAsInteger((Object)Trait.FONT_SIZE);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(fontname);
        int rx = this.currentIPPosition;
        int bl = this.currentBPPosition + area.getOffset() + area.getBaselineOffset();
        this.useFont(fontname, fontsize);
        ColorType ct = (ColorType)area.getTrait((Object)Trait.COLOR);
        if (ct != null) {
            try {
                this.useColor(ct);
            }
            catch (IOException ioe) {
                this.handleIOTrouble(ioe);
            }
        }
        boolean kerningAvailable = false;
        Map kerning = tf.getKerningInfo();
        if (kerning != null && !kerning.isEmpty()) {
            AbstractRenderer.log.warn("Kerning info is available, but kerning is not yet implemented for the PS renderer and not currently supported by the layout engine.");
        }
        this.beginTextObject();
        this.writeln("1 0 0 -1 " + this.gen.formatDouble((float)rx / 1000.0f) + " " + this.gen.formatDouble((float)bl / 1000.0f) + " Tm");
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        int textLen = text.length();
        if (area.getTextLetterSpaceAdjust() == 0 && area.getTextWordSpaceAdjust() == 0) {
            sb.append("(");
            int i = 0;
            while (i < textLen) {
                char c = text.charAt(i);
                char mapped = tf.mapChar(c);
                PSGenerator.escapeChar(mapped, sb);
                ++i;
            }
            sb.append(") t");
        } else {
            sb.append("(");
            int[] offsets = new int[textLen];
            int i = 0;
            while (i < textLen) {
                char c = text.charAt(i);
                char mapped = tf.mapChar(c);
                int wordSpace = CharUtilities.isAnySpace((char)mapped) && mapped != '\u200b' && mapped != '\ufeff' ? area.getTextWordSpaceAdjust() : 0;
                int cw = tf.getWidth(mapped, fontsize) / 1000;
                offsets[i] = cw + area.getTextLetterSpaceAdjust() + wordSpace;
                PSGenerator.escapeChar(mapped, sb);
                ++i;
            }
            sb.append(")\n[");
            int i2 = 0;
            while (i2 < textLen) {
                if (i2 > 0) {
                    if (i2 % 8 == 0) {
                        sb.append('\n');
                    } else {
                        sb.append(" ");
                    }
                }
                sb.append(this.gen.formatDouble((float)offsets[i2] / 1000.0f));
                ++i2;
            }
            sb.append("]\nxshow");
        }
        this.writeln(sb.toString());
        this.renderTextDecoration(tf, fontsize, (InlineArea)area, bl, rx);
    }

    protected List breakOutOfStateStack() {
        try {
            ArrayList<PSState> breakOutList = new ArrayList<PSState>();
            while (true) {
                if (breakOutList.size() == 0) {
                    this.endTextObject();
                    this.comment("------ break out!");
                }
                PSState state = this.gen.getCurrentState();
                if (!this.gen.restoreGraphicsState()) break;
                breakOutList.add(0, state);
            }
            return breakOutList;
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
            return null;
        }
    }

    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        try {
            this.comment("------ restoring context after break-out...");
            Iterator i = breakOutList.iterator();
            while (i.hasNext()) {
                PSState state = (PSState)i.next();
                this.saveGraphicsState();
                state.reestablish(this.gen);
            }
            this.comment("------ done.");
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void startVParea(CTM ctm) {
        this.saveGraphicsState();
        double[] matrix = ctm.toArray();
        matrix[4] = matrix[4] / 1000.0;
        matrix[5] = matrix[5] / 1000.0;
        this.concatMatrix(matrix);
    }

    protected void endVParea() {
        this.endTextObject();
        this.restoreGraphicsState();
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        this.comment("%FOPBeginBlockViewport: " + bv.toString());
        super.renderBlockViewport(bv, children);
        this.comment("%FOPEndBlockViewport");
    }

    protected void renderInlineParent(InlineParent ip) {
        super.renderInlineParent(ip);
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.drawImage(image.getURL(), pos);
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        this.endTextObject();
        RendererContext context = new RendererContext((AbstractRenderer)this, MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("psGenerator", (Object)this.gen);
        context.setProperty("psFontInfo", (Object)this.fontInfo);
        context.setProperty("width", (Object)new Integer((int)pos.getWidth()));
        context.setProperty("height", (Object)new Integer((int)pos.getHeight()));
        context.setProperty("xpos", (Object)new Integer(this.currentIPPosition + (int)pos.getX()));
        context.setProperty("ypos", (Object)new Integer(this.currentBPPosition + (int)pos.getY()));
        this.renderXML(context, doc, ns);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    static /* synthetic */ FOUserAgent access$001(PSRenderer x0) {
        return x0.userAgent;
    }
}

